/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.visualizer;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.aya.cube.compiler.CompiledCube;
import org.aya.cube.compiler.CompiledFace;
import org.aya.cube.compiler.CompiledLine;
import org.aya.cube.compiler.CubeDatabase;
import org.aya.cube.compiler.TextBuilder;
import org.aya.cube.compiler.Util;
import org.aya.cube.visualizer.CubeData;
import org.aya.cube.visualizer.FaceData;
import org.aya.cube.visualizer.ImData;
import org.aya.cube.visualizer.ImGuiTextBuilder;
import org.aya.cube.visualizer.LineData;
import org.aya.cube.visualizer.PointData;
import org.ice1000.jimgui.JImDrawList;
import org.ice1000.jimgui.JImGui;
import org.ice1000.jimgui.JImGuiIO;
import org.ice1000.jimgui.NativeBool;
import org.ice1000.jimgui.NativeFloat;
import org.ice1000.jimgui.NativeInt;
import org.ice1000.jimgui.NativeString;
import org.ice1000.jimgui.util.JImGuiUtil;
import org.ice1000.jimgui.util.JniLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuiMain
implements AutoCloseable {
    private final JImGui window;
    @NotNull
    private final NativeFloat cubeLen = new NativeFloat();
    private float userLen;
    private float projectedLen;
    private int alphaDiff = 0;
    private ArrayList<CompiledCube> database = new ArrayList();
    private final NativeString customPreamble = new NativeString();
    private final NativeInt cubeSelection = new NativeInt();
    private final CubeData cube = new CubeData();
    @Nullable
    private Object highlight;
    @NotNull
    public static Path CUBE_BIN = Paths.get("cubes.bin", new String[0]);
    private float thickness = 3.0f;

    public GuiMain(JImGui window) {
        this.window = window;
        this.cubeLen.modifyValue(100.0f);
    }

    @Override
    public void close() {
        this.window.close();
        this.cubeLen.close();
        this.cube.close();
        this.customPreamble.close();
        this.cubeSelection.close();
    }

    public static void main(String ... args) {
        JniLoader.load();
        JImGuiUtil.cacheStringToBytes();
        try (GuiMain ui = new GuiMain(new JImGui("Cube visualizer"));){
            ui.mainLoop();
        }
    }

    public void mainLoop() {
        while (!this.window.windowShouldClose()) {
            this.window.initNewFrame();
            if (this.window.begin("Rumor")) {
                this.previewWindow();
                GuiMain guiMain = this;
                guiMain.window.end();
            }
            if (this.window.begin("Ground Control")) {
                this.mainControlWindow();
                GuiMain guiMain = this;
                guiMain.window.end();
            }
            if (this.window.begin("Early Song")) {
                this.tikzWindow();
                GuiMain guiMain = this;
                guiMain.window.end();
            }
            if (this.window.begin("Cube Database")) {
                this.cubeDatabaseWindow();
                GuiMain guiMain = this;
                guiMain.window.end();
            }
            this.window.render();
        }
    }

    private void cubeDatabaseWindow() {
        if (this.window.button("Save cubes.bin")) {
            Util.save((Path)CUBE_BIN, (CubeDatabase)new CubeDatabase(this.customPreamble.toBytes(), this.database));
        }
        this.window.sameLine();
        if (this.window.button("Load cubes.bin")) {
            try {
                CubeDatabase cubeDatabase = Util.tryLoad((Path)CUBE_BIN);
                this.customPreamble.clear();
                for (byte b : cubeDatabase.customPreamble()) {
                    this.customPreamble.append(b);
                }
                this.database = cubeDatabase.cubes();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.window.button("Append")) {
            this.database.add(this.cube.serialize());
        }
        JImGui.pushID((int)ImData.ID.CubeRadio.id);
        int toRemove = -1;
        int toMoveUp = -1;
        int toMoveDown = -1;
        for (int i = 0; i < this.database.size(); ++i) {
            int ix;
            CompiledCube deserialize = this.database.get(i);
            String text = new String(deserialize.name(), StandardCharsets.US_ASCII);
            if (this.window.smallButton("Up##" + i)) {
                toMoveUp = i;
            }
            this.window.sameLine();
            if (this.window.smallButton("Down##" + i)) {
                toMoveDown = i;
            }
            this.window.sameLine();
            boolean hasAction = this.window.radioButton(text, this.cubeSelection, i);
            this.window.sameLine();
            if (this.window.button("Delete##" + i)) {
                toRemove = i;
                hasAction = true;
            }
            if (!hasAction || (ix = this.cubeSelection.accessValue()) < 0 || ix >= this.database.size()) continue;
            this.cube.deserialize(deserialize);
        }
        if (toRemove >= 0) {
            this.database.remove(toRemove);
        }
        if (toMoveUp > 0) {
            CompiledCube a = this.database.get(toMoveUp);
            CompiledCube b = this.database.get(toMoveUp - 1);
            this.database.set(toMoveUp, b);
            this.database.set(toMoveUp - 1, a);
        }
        if (toMoveDown >= 0 && toMoveDown < this.database.size() - 1) {
            CompiledCube a = this.database.get(toMoveDown);
            CompiledCube b = this.database.get(toMoveDown + 1);
            this.database.set(toMoveDown, b);
            this.database.set(toMoveDown + 1, a);
        }
        GuiMain guiMain = this;
        guiMain.window.popID();
    }

    private void tikzWindow() {
        CompiledCube serialize = this.cube.serialize();
        if (this.window.button("Copy TikZ")) {
            TextBuilder.Strings sb = new TextBuilder.Strings();
            serialize.buildText((TextBuilder)sb, this.highlight);
            this.window.setClipboardText(sb.sb().toString());
        }
        this.window.sameLine();
        if (this.window.button("Copy preamble")) {
            this.window.setClipboardText("\\pgfdeclarelayer{frontmost}\n\\pgfsetlayers{main,frontmost}\n\\usetikzlibrary{patterns}\n\n\\tikzset{\n  carlo-axes/.style = { y = {(0,-1)}, z = {(-0.6,0.6)} } ,\n  shorten <>/.style = { shorten >=#1 , shorten <=#1 } ,\n  equals arrow/.style = {\n    arrows = - ,\n    double equal sign distance ,\n  } ,\n}\n\n\\newcommand{\\carloTikZ}[1]{\n  \\begin{tikzpicture}[carlo-axes, scale = 2, arrows = ->]\n  #1\n  \\end{tikzpicture}}\n");
        }
        serialize.buildText((TextBuilder)new ImGuiTextBuilder(this.window), this.highlight);
    }

    private void mainControlWindow() {
        this.window.getIO();
        this.window.text("FPS: " + JImGuiIO.getFramerate());
        this.window.sliderFloat("Width", this.cubeLen, 5.0f, 200.0f);
        this.window.inputText("Name", this.cube.name(), 16);
        boolean hasHover = this.cubeFaces(this.cube);
        GuiMain guiMain = this;
        guiMain.window.separator();
        hasHover = this.cubeEdges(this.cube) || hasHover;
        GuiMain guiMain2 = this;
        guiMain2.window.separator();
        boolean bl = hasHover = this.cubePoints(this.cube) || hasHover;
        if (!hasHover) {
            this.highlight = null;
        }
    }

    private boolean cubePoints(CubeData cube) {
        this.window.text("Points");
        if (!this.window.beginTabBar("Points")) {
            return false;
        }
        boolean hasHover = false;
        for (int i = 0; i <= 7; ++i) {
            String name = Util.binPad3((int)i);
            boolean beginTabItem = this.window.beginTabItem(name + "##Pt");
            if (this.window.isItemHovered()) {
                hasHover = true;
                this.highlight = i;
            }
            if (!beginTabItem) continue;
            PointData ptr = cube.vertices()[i];
            this.window.inputText("##Input" + name, ptr.latex());
            GuiMain guiMain = this;
            guiMain.window.endTabItem();
        }
        GuiMain guiMain = this;
        guiMain.window.endTabBar();
        return hasHover;
    }

    private boolean cubeEdges(CubeData cube) {
        this.window.text("Lines");
        if (!this.window.beginTabBar("Edges")) {
            return false;
        }
        boolean hasHover = false;
        for (CompiledLine.Side side : CompiledLine.Side.values()) {
            boolean beginTabItem = this.window.beginTabItem(ImData.sideTabItem[side.ordinal()]);
            if (this.window.isItemHovered()) {
                hasHover = true;
                this.highlight = side;
            }
            if (!beginTabItem) continue;
            LineData ptr = cube.lines()[side.ordinal()];
            NativeBool hidden = ptr.isHidden();
            this.window.toggleButton(ImData.sideHidden[side.ordinal()], hidden);
            this.window.sameLine();
            this.window.text("Hidden");
            if (!hidden.accessValue()) {
                this.window.toggleButton(ImData.sideDashed[side.ordinal()], ptr.isDashed());
                this.window.sameLine();
                this.window.text("Dashed");
                this.window.toggleButton(ImData.sideEqual[side.ordinal()], ptr.isEqual());
                this.window.sameLine();
                this.window.text("Equal");
            }
            GuiMain guiMain = this;
            guiMain.window.endTabItem();
        }
        GuiMain guiMain = this;
        guiMain.window.endTabBar();
        return hasHover;
    }

    private boolean cubeFaces(CubeData cube) {
        if (!this.window.beginTabBar("Faces")) {
            return false;
        }
        boolean hasHover = false;
        for (CompiledFace.Orient face : CompiledFace.Orient.values()) {
            boolean beginTabItem = this.window.beginTabItem(ImData.orientTabItem[face.ordinal()]);
            if (this.window.isItemHovered()) {
                hasHover = true;
                this.highlight = face;
            }
            if (!beginTabItem) continue;
            FaceData ptr = cube.faces()[face.ordinal()];
            JImGui.pushID((int)ImData.ID.StatusRadio.id);
            for (CompiledFace.Status status : CompiledFace.Status.values()) {
                this.window.radioButton(ImData.orientToggle[face.ordinal()][status.ordinal()], ptr.status(), status.ordinal());
                if (status != CompiledFace.Status.Lines || !this.window.isItemHovered()) continue;
                GuiMain guiMain = this;
                guiMain.window.beginTooltip();
                this.window.text("Displayed as shaded");
                GuiMain guiMain2 = this;
                guiMain2.window.endTooltip();
            }
            GuiMain guiMain = this;
            guiMain.window.popID();
            this.window.inputTextWithHint(ImData.orientInput[face.ordinal()], ImData.latexCodeStr, ptr.latex());
            GuiMain guiMain3 = this;
            guiMain3.window.endTabItem();
        }
        GuiMain guiMain = this;
        guiMain.window.endTabBar();
        return hasHover;
    }

    private void previewWindow() {
        GuiMain guiMain = this;
        float x = guiMain.window.getWindowPosX();
        GuiMain guiMain2 = this;
        float y = guiMain2.window.getWindowPosY();
        this.userLen = this.cubeLen.accessValue();
        this.projectedLen = this.userLen * 0.6f;
        this.drawCubeAt(x + 30.0f, y + 30.0f);
    }

    private void drawCubeAt(float baseX, float baseY) {
        if (this.wantDraw(CompiledFace.Orient.Top)) {
            this.hParallelogram(baseX, baseY);
        }
        if (this.wantDraw(CompiledFace.Orient.Left)) {
            this.vParallelogram(baseX, baseY);
        }
        if (this.wantDraw(CompiledFace.Orient.Front)) {
            this.square(baseX, baseY + this.projectedLen);
        }
        if (this.wantDraw(CompiledFace.Orient.Bottom)) {
            this.hParallelogram(baseX, baseY + this.userLen);
        }
        if (this.wantDraw(CompiledFace.Orient.Back)) {
            this.square(baseX + this.projectedLen, baseY);
        }
        if (this.wantDraw(CompiledFace.Orient.Right)) {
            this.vParallelogram(baseX + this.userLen, baseY);
        }
        if (this.wantDraw(CompiledLine.Side.TF)) {
            this.hline(baseX, baseY + this.projectedLen);
        }
        if (this.wantDraw(CompiledLine.Side.TB)) {
            this.hline(baseX + this.projectedLen, baseY);
        }
        if (this.wantDraw(CompiledLine.Side.TL)) {
            this.aline(baseX, baseY);
        }
        if (this.wantDraw(CompiledLine.Side.TR)) {
            this.aline(baseX + this.userLen, baseY);
        }
        if (this.wantDraw(CompiledLine.Side.BF)) {
            this.hline(baseX, baseY + this.projectedLen + this.userLen);
        }
        if (this.wantDraw(CompiledLine.Side.BB)) {
            this.hline(baseX + this.projectedLen, baseY + this.userLen);
        }
        if (this.wantDraw(CompiledLine.Side.BL)) {
            this.aline(baseX, baseY + this.userLen);
        }
        if (this.wantDraw(CompiledLine.Side.BR)) {
            this.aline(baseX + this.userLen, baseY + this.userLen);
        }
        if (this.wantDraw(CompiledLine.Side.LB)) {
            this.vline(baseX + this.projectedLen, baseY);
        }
        if (this.wantDraw(CompiledLine.Side.LF)) {
            this.vline(baseX, baseY + this.projectedLen);
        }
        if (this.wantDraw(CompiledLine.Side.RB)) {
            this.vline(baseX + this.projectedLen + this.userLen, baseY);
        }
        if (this.wantDraw(CompiledLine.Side.RF)) {
            this.vline(baseX + this.userLen, baseY + this.projectedLen);
        }
        JImDrawList ui = this.window.getWindowDrawList();
        Util.forEach3D((i, x, y, z) -> {
            float centreX = baseX + this.projectedLen + (float)x * this.userLen - (float)z * this.projectedLen;
            float centreY = baseY + (float)y * this.userLen + (float)z * this.projectedLen;
            if (this.highlight == Integer.valueOf(i)) {
                ui.addCircleFilled(centreX, centreY, 4.0f, -16776961);
            } else {
                ui.addCircle(centreX, centreY, 4.0f, -16776961);
            }
            return null;
        });
    }

    private boolean wantDraw(CompiledFace.Orient face) {
        if (this.highlight == face) {
            this.alphaDiff = 0x40000000;
            return true;
        }
        this.alphaDiff = 0;
        return this.cube.enabled(face);
    }

    private boolean wantDraw(CompiledLine.Side side) {
        float f = this.thickness = this.cube.doubled(side) ? 3.0f : 1.0f;
        if (this.highlight == side) {
            this.alphaDiff = 0x40000000;
            return true;
        }
        this.alphaDiff = 0;
        return this.cube.enabled(side);
    }

    private void hline(float x, float y) {
        JImDrawList ui = this.window.getWindowDrawList();
        ui.addLine(x, y, x + this.userLen, y, -1713528611 + this.alphaDiff, this.thickness);
    }

    private void vline(float x, float y) {
        JImDrawList ui = this.window.getWindowDrawList();
        ui.addLine(x, y, x, y + this.userLen, -1713528611 + this.alphaDiff, this.thickness);
    }

    private void aline(float x, float y) {
        JImDrawList ui = this.window.getWindowDrawList();
        ui.addLine(x + this.projectedLen, y, x, y + this.projectedLen, -1713528611 + this.alphaDiff, this.thickness);
    }

    private void hParallelogram(float x, float y) {
        JImDrawList ui = this.window.getWindowDrawList();
        ui.addQuadFilled(x + this.projectedLen, y, x + this.projectedLen + this.userLen, y, x + this.userLen, y + this.projectedLen, x, y + this.projectedLen, -2002059520 - this.alphaDiff);
    }

    private void square(float x, float y) {
        JImDrawList ui = this.window.getWindowDrawList();
        ui.addRectFilled(x, y, x + this.userLen, y + this.userLen, -2012090693 - this.alphaDiff);
    }

    private void vParallelogram(float x, float y) {
        JImDrawList ui = this.window.getWindowDrawList();
        ui.addQuadFilled(x + this.projectedLen, y, x + this.projectedLen, y + this.userLen, x, y + this.userLen + this.projectedLen, x, y + this.projectedLen, -1999853005 - this.alphaDiff);
    }
}

