/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.visualizer;

import java.util.Arrays;
import org.aya.cube.compiler.CompiledCube;
import org.aya.cube.compiler.CompiledFace;
import org.aya.cube.compiler.CompiledLine;
import org.aya.cube.compiler.CompiledPoint;
import org.aya.cube.visualizer.FaceData;
import org.aya.cube.visualizer.LineData;
import org.aya.cube.visualizer.PointData;
import org.ice1000.jimgui.NativeString;
import org.jetbrains.annotations.NotNull;

public record CubeData(@NotNull NativeString name, @NotNull @NotNull PointData @NotNull [] vertices, @NotNull @NotNull LineData @NotNull [] lines, @NotNull @NotNull FaceData @NotNull [] faces) implements AutoCloseable
{
    public CubeData() {
        this(new NativeString(), new PointData[8], new LineData[CompiledLine.Side.values().length], new FaceData[CompiledFace.Orient.values().length]);
    }

    public CubeData(@NotNull NativeString name, @NotNull PointData[] vertices, @NotNull LineData[] lines, @NotNull FaceData[] faces) {
        for (CompiledFace.Orient orient : CompiledFace.Orient.values()) {
            faces[orient.ordinal()] = new FaceData();
        }
        for (CompiledFace.Orient orient : CompiledLine.Side.values()) {
            lines[orient.ordinal()] = new LineData();
        }
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = new PointData();
        }
    }

    public boolean enabled(CompiledFace.Orient orientation) {
        return this.faces[orientation.ordinal()].enabled();
    }

    public boolean enabled(CompiledLine.Side orientation) {
        return !this.lines[orientation.ordinal()].isHidden().accessValue();
    }

    public boolean doubled(CompiledLine.Side orientation) {
        return this.lines[orientation.ordinal()].isEqual().accessValue();
    }

    @Override
    public void close() {
        for (FaceData faceData : this.faces) {
            faceData.close();
        }
        for (Record record : this.lines) {
            ((LineData)record).close();
        }
        for (Record record : this.vertices) {
            ((PointData)record).close();
        }
        this.name.close();
    }

    @NotNull
    public CompiledCube serialize() {
        return new CompiledCube(this.name.toBytes(), (CompiledPoint[])Arrays.stream(this.vertices).map(PointData::serialize).toArray(CompiledPoint[]::new), (CompiledLine[])Arrays.stream(this.lines).map(LineData::serialize).toArray(CompiledLine[]::new), (CompiledFace[])Arrays.stream(this.faces).map(FaceData::serialize).toArray(CompiledFace[]::new));
    }

    public void deserialize(@NotNull CompiledCube serialized) {
        int i;
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].deserialize(serialized.vertices()[i]);
        }
        for (i = 0; i < this.lines.length; ++i) {
            this.lines[i].deserialize(serialized.lines()[i]);
        }
        for (i = 0; i < this.faces.length; ++i) {
            this.faces[i].deserialize(serialized.faces()[i]);
        }
    }
}

