/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import org.aya.cube.compiler.CompiledCube;
import org.aya.cube.compiler.TextBuilder;
import org.jetbrains.annotations.NotNull;

public record CubeDatabase(byte @NotNull [] customPreamble, @NotNull ArrayList<CompiledCube> cubes) implements Serializable
{
    public void buildText(@NotNull TextBuilder builder) {
        builder.appendln("\\documentclass{article}\n\\usepackage[utf8]{inputenc}\n\\usepackage{tikz}\n\\usepackage{mathpazo}\n\n\\title{Cubes \\`a la Carlo Angiuli}\n\\author{Tesla Zhang}\n\\date{\\today}\n", false);
        builder.append(this.customPreamble, false);
        builder.appendln("\\pgfdeclarelayer{frontmost}\n\\pgfsetlayers{main,frontmost}\n\\usetikzlibrary{patterns}\n\n\\tikzset{\n  carlo-axes/.style = { y = {(0,-1)}, z = {(-0.6,0.6)} } ,\n  shorten <>/.style = { shorten >=#1 , shorten <=#1 } ,\n  equals arrow/.style = {\n    arrows = - ,\n    double equal sign distance ,\n  } ,\n}\n\n\\newcommand{\\carloTikZ}[1]{\n  \\begin{tikzpicture}[carlo-axes, scale = 1.6]\n  #1\n  \\end{tikzpicture}}\n", false);
        builder.appendln("\\begin{document}\\maketitle{}\\tableofcontents{}\\newpage{}", false);
        this.cubes.forEach(cube -> {
            builder.append("\\section{", false);
            builder.append(cube.name(), false);
            builder.appendln("}\\begin{center}", false);
            cube.buildText(builder, null);
            builder.appendln("\\end{center}", false);
        });
        builder.appendln("\\end{document}", false);
    }
}

