/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.compiler;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.aya.cube.compiler.TextBuilder;
import org.aya.cube.compiler.Util;
import org.jetbrains.annotations.NotNull;

public record CompiledFace(int status, byte @NotNull [] latex) implements Serializable
{
    public void buildText(@NotNull TextBuilder builder, Orient orient, boolean isHighlight) {
        String draw = "";
        switch (Status.values()[this.status]) {
            case Shaded: {
                draw = "\\fill[fill=black, fill opacity=0.2, draw=white, draw opacity=0, line width=2.5pt]";
                break;
            }
            case Lines: {
                draw = "\\fill[pattern color=lightgray,pattern=north west lines]";
                break;
            }
            case Invisible: {
                return;
            }
        }
        builder.appendln(draw, isHighlight);
        builder.appendln(orient.tikz + " -- cycle ;", isHighlight);
        if (this.latex.length != 0) {
            builder.append("\\node (" + orient.name() + ") at (" + orient.center + ") {", isHighlight);
            builder.append(this.latex, isHighlight);
            builder.appendln("} ;", isHighlight);
        }
        builder.appendln("% ^ " + orient.name(), isHighlight);
    }

    public static enum Status {
        Invisible,
        Shaded,
        Lines;

    }

    public static enum Orient {
        Top(new int[]{0, 4, 5, 1}),
        Bottom(new int[]{2, 6, 7, 3}),
        Front(new int[]{1, 5, 7, 3}),
        Back(new int[]{0, 4, 6, 2}),
        Left(new int[]{0, 2, 3, 1}),
        Right(new int[]{4, 6, 7, 5});

        public final int @NotNull [] vertices;
        @NotNull
        public final String tikz;
        @NotNull
        public final String center;

        public boolean contains(int i) {
            return Arrays.stream(this.vertices).anyMatch(v -> v == i);
        }

        private Orient(int[] vertices) {
            this.vertices = vertices;
            this.tikz = Arrays.stream(vertices).mapToObj(i -> Util.apply3D(i, ($, x, y, z) -> x + "," + y + "," + z)).collect(Collectors.joining(") -- (", "(", ")"));
            int[] sums = new int[]{0, 0, 0};
            Arrays.stream(vertices).forEach(i -> Util.apply3D(i, ($, x, y, z) -> {
                sums[0] = sums[0] + x;
                sums[1] = sums[1] + y;
                sums[2] = sums[2] + z;
                return sums[2];
            }));
            this.center = (float)sums[0] / 4.0f + "," + (float)sums[1] / 4.0f + "," + (float)sums[2] / 4.0f;
        }
    }
}

