/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.compiler;

import java.io.Serializable;
import org.aya.cube.compiler.CompiledFace;
import org.aya.cube.compiler.CompiledLine;
import org.aya.cube.compiler.CompiledPoint;
import org.aya.cube.compiler.TextBuilder;
import org.aya.cube.compiler.Util;
import org.jetbrains.annotations.NotNull;

public record CompiledCube(byte @NotNull [] name, @NotNull @NotNull CompiledPoint @NotNull [] vertices, @NotNull @NotNull CompiledLine @NotNull [] lines, @NotNull @NotNull CompiledFace @NotNull [] faces) implements Serializable
{
    public void buildText(@NotNull TextBuilder builder, Object highlight) {
        builder.appendln("\\carloTikZ{", false);
        builder.append("%<*", false);
        builder.append(this.name, false);
        builder.appendln(">", false);
        builder.appendln("\\begin{pgfonlayer}{frontmost}\\begin{scope}[every node/.style = {inner sep = 0pt}]", false);
        Util.forEach3D((i, x, y, z) -> {
            boolean isHighlight = highlight == Integer.valueOf(i);
            builder.append("\\node (" + Util.binPad3(i) + ") at (" + x + "," + y + "," + z + ") {\\(", isHighlight);
            builder.append(this.vertices[i].latex(), isHighlight);
            builder.appendln("\\)};", isHighlight);
            return null;
        });
        builder.appendln("\\end{scope}\\end{pgfonlayer}", false);
        builder.appendln("\\begin{scope}[transparency group=knockout]", false);
        for (CompiledFace.Orient orient : CompiledFace.Orient.values()) {
            if (!orient.contains(2)) continue;
            this.faces[orient.ordinal()].buildText(builder, orient, highlight == orient);
        }
        for (Enum enum_ : CompiledLine.Side.values()) {
            if (!((CompiledLine.Side)enum_).isLowerLayer()) continue;
            this.lines[enum_.ordinal()].buildText(builder, (CompiledLine.Side)enum_, highlight == enum_);
        }
        builder.appendln("\\end{scope}", false);
        builder.appendln("\\begin{scope}[transparency group=knockout]", false);
        for (Enum enum_ : CompiledFace.Orient.values()) {
            if (((CompiledFace.Orient)enum_).contains(2)) continue;
            this.faces[enum_.ordinal()].buildText(builder, (CompiledFace.Orient)enum_, highlight == enum_);
        }
        for (Enum enum_ : CompiledLine.Side.values()) {
            if (((CompiledLine.Side)enum_).isLowerLayer()) continue;
            this.lines[enum_.ordinal()].buildText(builder, (CompiledLine.Side)enum_, highlight == enum_);
        }
        builder.appendln("\\end{scope}", false);
        builder.append("%</", false);
        builder.append(this.name, false);
        builder.appendln(">", false);
        builder.appendln("}", false);
    }
}

