/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.compiler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.aya.cube.compiler.CubeDatabase;
import org.aya.cube.compiler.TextBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface Util {
    @NotNull
    @NonNls
    public static final String veryPrefix = "\\documentclass{article}\n\\usepackage[utf8]{inputenc}\n\\usepackage{tikz}\n\\usepackage{mathpazo}\n\n\\title{Cubes \\`a la Carlo Angiuli}\n\\author{Tesla Zhang}\n\\date{\\today}\n";
    @NotNull
    @NonNls
    public static final String carloPreamble = "\\pgfdeclarelayer{frontmost}\n\\pgfsetlayers{main,frontmost}\n\\usetikzlibrary{patterns}\n\n\\tikzset{\n  carlo-axes/.style = { y = {(0,-1)}, z = {(-0.6,0.6)} } ,\n  shorten <>/.style = { shorten >=#1 , shorten <=#1 } ,\n  equals arrow/.style = {\n    arrows = - ,\n    double equal sign distance ,\n  } ,\n}\n\n\\newcommand{\\carloTikZ}[1]{\n  \\begin{tikzpicture}[carlo-axes, scale = 2, arrows = ->]\n  #1\n  \\end{tikzpicture}}\n";

    @NotNull
    public static String binPad3(int i) {
        return String.format("%3s", Integer.toString(i, 2)).replace(' ', '0');
    }

    public static void main(Path in, Path out) throws IOException, ClassNotFoundException {
        TextBuilder.Strings builder = new TextBuilder.Strings();
        Util.tryLoad(in).buildText(builder);
        Files.writeString(out, (CharSequence)builder.sb(), StandardCharsets.US_ASCII, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    }

    public static void forEach3D(@NotNull Action3D<?> action) {
        for (int i = 0; i <= 7; ++i) {
            Util.apply3D(i, action);
        }
    }

    public static <T> T apply3D(int i, @NotNull Action3D<T> action) {
        boolean zz = (i & 1) > 0;
        boolean yy = (i & 2) > 0;
        boolean xx = (i & 4) > 0;
        int z = zz ? 1 : 0;
        int y = yy ? 1 : 0;
        int x = xx ? 1 : 0;
        return action.apply(i, x, y, z);
    }

    @NotNull
    public static CubeDatabase tryLoad(@NotNull Path path) throws IOException, ClassNotFoundException {
        return (CubeDatabase)new ObjectInputStream(Files.newInputStream(path, new OpenOption[0])).readObject();
    }

    @NotNull
    public static CubeDatabase load(@NotNull Path path) {
        try {
            return Util.tryLoad(path);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void trySave(@NotNull Path path, @NotNull CubeDatabase cube) throws IOException {
        new ObjectOutputStream(Files.newOutputStream(path, new OpenOption[0])).writeObject(cube);
    }

    public static void save(@NotNull Path path, @NotNull CubeDatabase cube) {
        try {
            Util.trySave(path, cube);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface Action3D<T> {
        public T apply(int var1, int var2, int var3, int var4);
    }
}

