/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.aya.cube.compiler.CompiledFace;
import org.aya.cube.compiler.TextBuilder;
import org.aya.cube.compiler.Util;
import org.jetbrains.annotations.NotNull;

public record CompiledLine(boolean isHidden, boolean isDashed, boolean isEqual) implements Serializable
{
    public void buildText(@NotNull TextBuilder builder, Side side, boolean isHighlight) {
        if (this.isHidden) {
            return;
        }
        ArrayList<String> attrs = new ArrayList<String>(){
            {
                this.add("double");
            }
        };
        if (this.isEqual) {
            attrs.add("equals arrow");
        }
        if (this.isDashed) {
            attrs.add("dashed");
        }
        builder.appendln("\\draw " + attrs + " (" + side.from + ") -- (" + side.to + ") ;", isHighlight);
    }

    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side TF = new Side(CompiledFace.Orient.Top, CompiledFace.Orient.Front);
        public static final /* enum */ Side BF = new Side(CompiledFace.Orient.Bottom, CompiledFace.Orient.Front);
        public static final /* enum */ Side TB = new Side(CompiledFace.Orient.Top, CompiledFace.Orient.Back);
        public static final /* enum */ Side BB = new Side(CompiledFace.Orient.Bottom, CompiledFace.Orient.Back);
        public static final /* enum */ Side TL = new Side(CompiledFace.Orient.Top, CompiledFace.Orient.Left);
        public static final /* enum */ Side BL = new Side(CompiledFace.Orient.Bottom, CompiledFace.Orient.Left);
        public static final /* enum */ Side TR = new Side(CompiledFace.Orient.Top, CompiledFace.Orient.Right);
        public static final /* enum */ Side BR = new Side(CompiledFace.Orient.Bottom, CompiledFace.Orient.Right);
        public static final /* enum */ Side LF = new Side(CompiledFace.Orient.Left, CompiledFace.Orient.Front);
        public static final /* enum */ Side RF = new Side(CompiledFace.Orient.Right, CompiledFace.Orient.Front);
        public static final /* enum */ Side LB = new Side(CompiledFace.Orient.Left, CompiledFace.Orient.Back);
        public static final /* enum */ Side RB = new Side(CompiledFace.Orient.Right, CompiledFace.Orient.Back);
        public final CompiledFace.Orient adjacent0;
        public final CompiledFace.Orient adjacent1;
        public final String from;
        public final String to;
        private static final /* synthetic */ Side[] $VALUES;

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String name) {
            return Enum.valueOf(Side.class, name);
        }

        private Side(CompiledFace.Orient adjacent0, CompiledFace.Orient adjacent1) {
            this.adjacent0 = adjacent0;
            this.adjacent1 = adjacent1;
            int[] common = Arrays.stream(adjacent0.vertices).filter(adjacent1::contains).sorted().toArray();
            assert (common.length == 2);
            this.from = Util.binPad3(common[0]);
            this.to = Util.binPad3(common[1]);
        }

        private static /* synthetic */ Side[] $values() {
            return new Side[]{TF, BF, TB, BB, TL, BL, TR, BR, LF, RF, LB, RB};
        }

        static {
            $VALUES = Side.$values();
        }
    }
}

