/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cube.compiler;

import java.io.Serializable;
import org.aya.cube.compiler.CompiledFace;
import org.aya.cube.compiler.CompiledLine;
import org.aya.cube.compiler.CompiledPoint;
import org.aya.cube.compiler.TextBuilder;
import org.aya.cube.compiler.Util;
import org.jetbrains.annotations.NotNull;

public record CompiledCube(byte @NotNull [] name, @NotNull @NotNull CompiledPoint @NotNull [] vertices, @NotNull @NotNull CompiledLine @NotNull [] lines, @NotNull @NotNull CompiledFace @NotNull [] faces) implements Serializable
{
    public void buildText(@NotNull TextBuilder builder, Object highlight) {
        builder.append("%<*", false);
        builder.append(this.name, false);
        builder.appendln(">", false);
        builder.appendln("\\carloTikZ{\\begin{pgfonlayer}{frontmost}", false);
        Util.forEach3D((i, x, y, z) -> {
            boolean isHighlight = highlight == Integer.valueOf(i);
            builder.append("\\node (" + Util.binPad3(i) + ") at (" + x + "," + y + "," + z + ") {\\(", isHighlight);
            builder.append(this.vertices[i].latex(), isHighlight);
            builder.appendln("\\)};", isHighlight);
            return null;
        });
        builder.appendln("\\end{pgfonlayer}", false);
        for (CompiledFace.Orient orient : CompiledFace.Orient.values()) {
            this.faces[orient.ordinal()].buildText(builder, orient, highlight == orient);
        }
        for (Enum enum_ : CompiledLine.Side.values()) {
            if (((CompiledLine.Side)enum_).adjacent1 != CompiledFace.Orient.Back) continue;
            this.lines[enum_.ordinal()].buildText(builder, (CompiledLine.Side)enum_, highlight == enum_);
        }
        for (Enum enum_ : CompiledLine.Side.values()) {
            if (((CompiledLine.Side)enum_).adjacent1 == CompiledFace.Orient.Back) continue;
            this.lines[enum_.ordinal()].buildText(builder, (CompiledLine.Side)enum_, highlight == enum_);
        }
        builder.appendln("}", false);
        builder.append("%</", false);
        builder.append(this.name, false);
        builder.appendln(">", false);
    }
}

