/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.utils;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import org.aya.cli.render.Color;
import org.aya.cli.render.RenderOptions;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.VisibleForTesting;

public class LiteratePrettierOptions {
    @NotNull
    public AyaPrettierOptions prettierOptions = AyaPrettierOptions.pretty();
    public @UnknownNullability RenderOptions renderOptions = new RenderOptions();

    public void checkDeserialization() {
        if (this.prettierOptions.map.isEmpty()) {
            this.prettierOptions.reset();
        }
        if (this.renderOptions == null) {
            this.renderOptions = new RenderOptions();
        }
        this.renderOptions.checkDeserialization();
        try {
            this.renderOptions.stylist(RenderOptions.OutputTarget.Unix);
        }
        catch (JsonParseException | IOException e) {
            System.err.println("Failed to load stylist from config file, using default stylist instead.");
        }
    }

    @VisibleForTesting
    @NotNull
    public static GsonBuilder gsonBuilder(@NotNull GsonBuilder builder) {
        return builder.registerTypeAdapter(Color.class, (Object)new Color.Adapter()).registerTypeAdapter(PrettierOptions.Key.class, (json, typeOfT, context) -> {
            try {
                return AyaPrettierOptions.Key.valueOf((String)json.getAsString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        });
    }
}

