/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.single;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Function;
import kala.collection.immutable.ImmutableSeq;
import kala.function.CheckedRunnable;
import org.aya.cli.single.CompilerFlags;
import org.aya.cli.single.SingleAyaFile;
import org.aya.cli.utils.CliEnums;
import org.aya.cli.utils.CompilerUtil;
import org.aya.generic.AyaDocile;
import org.aya.primitive.PrimFactory;
import org.aya.producer.AyaParserImpl;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.module.CachedModuleLoader;
import org.aya.resolve.module.FileModuleLoader;
import org.aya.resolve.module.ModuleCallback;
import org.aya.resolve.module.ModuleListLoader;
import org.aya.resolve.module.ModuleLoader;
import org.aya.syntax.GenericAyaFile;
import org.aya.syntax.GenericAyaParser;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.reporter.CollectingReporter;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SingleFileCompiler {
    @NotNull
    public final CollectingReporter reporter;
    @NotNull
    public final CompilerFlags flags;
    @NotNull
    public final SourceFileLocator locator;
    @NotNull
    public final AyaParserImpl ayaParser;
    @NotNull
    public final SingleAyaFile.Factory fileManager;
    @NotNull
    public final ModuleLoader loader;

    public SingleFileCompiler(@NotNull Reporter baseReporter, @NotNull CompilerFlags flags, @Nullable SourceFileLocator baseLocator) {
        this.flags = flags;
        this.reporter = CollectingReporter.delegate((Reporter)baseReporter);
        this.locator = baseLocator != null ? baseLocator : new SourceFileLocator.Module(flags.modulePaths());
        this.ayaParser = new AyaParserImpl((Reporter)this.reporter);
        this.fileManager = new SingleAyaFile.Factory((Reporter)this.reporter);
        this.loader = new CachedModuleLoader((ModuleLoader)new ModuleListLoader((Reporter)this.reporter, flags.modulePaths().map(path -> new FileModuleLoader(this.locator, path, (Reporter)this.reporter, (GenericAyaParser)this.ayaParser, (GenericAyaFile.Factory)this.fileManager)).toImmutableSeq()));
    }

    public <E extends IOException> int compile(@NotNull Path sourceFile, @Nullable ModuleCallback<E> moduleCallback) throws IOException {
        return this.compile(sourceFile, reporter -> new EmptyContext(reporter, sourceFile).derive("Mian"), moduleCallback);
    }

    public <E extends IOException> int compile(@NotNull Path sourceFile, @NotNull Function<Reporter, ModuleContext> context, @Nullable ModuleCallback<E> moduleCallback) throws IOException {
        return CompilerUtil.catching((CountingReporter)this.reporter, this.flags, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {
            ModuleContext ctx = (ModuleContext)context.apply((Reporter)this.reporter);
            SingleAyaFile ayaFile = this.fileManager.createAyaFile(this.locator, sourceFile);
            ImmutableSeq program = ayaFile.parseMe((GenericAyaParser)this.ayaParser);
            ayaFile.pretty(this.flags, (ImmutableSeq<? extends AyaDocile>)program, this.reporter, CliEnums.PrettyStage.raw);
            this.loader.tyckModule(new PrimFactory(), ctx, program, (resolveInfo, defs) -> {
                ayaFile.tyckAdditional(resolveInfo);
                ayaFile.pretty(this.flags, (ImmutableSeq<? extends AyaDocile>)program, this.reporter, CliEnums.PrettyStage.scoped);
                ayaFile.pretty(this.flags, (ImmutableSeq<? extends AyaDocile>)defs, this.reporter, CliEnums.PrettyStage.typed);
                ayaFile.pretty(this.flags, (ImmutableSeq<? extends AyaDocile>)program, this.reporter, CliEnums.PrettyStage.literate);
                if (moduleCallback != null) {
                    moduleCallback.onModuleTycked(resolveInfo, defs);
                }
            });
        }));
    }
}

