/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.text.StringSlice;
import kala.tuple.Tuple2;
import org.aya.cli.literate.FaithfulPrettier;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.literate.SyntaxHighlight;
import org.aya.cli.utils.InlineHintProblem;
import org.aya.literate.Literate;
import org.aya.literate.LiterateConsumer;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.literate.AyaLiterate;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public record LiterateFaithfulPrettier(@NotNull ImmutableSeq<Problem> problems, @NotNull ImmutableSeq<HighlightInfo> highlights, @NotNull PrettierOptions options) implements LiterateConsumer,
FaithfulPrettier
{
    public void accept(@NotNull Literate literate) {
        if (literate instanceof Literate.CodeBlock) {
            Literate.CodeBlock block = (Literate.CodeBlock)literate;
            if (block.sourcePos != null) {
                Literate.CodeBlock codeBlock = block;
                Objects.requireNonNull(codeBlock);
                Literate.CodeBlock codeBlock2 = codeBlock;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AyaLiterate.AyaVisibleCodeBlock.class, AyaLiterate.AyaLexerCodeBlock.class}, (Object)codeBlock2, n)) {
                    case 0: {
                        AyaLiterate.AyaVisibleCodeBlock code = (AyaLiterate.AyaVisibleCodeBlock)codeBlock2;
                        code.highlighted = this.highlight(code.code, code.sourcePos);
                        break;
                    }
                    case 1: {
                        AyaLiterate.AyaLexerCodeBlock code = (AyaLiterate.AyaLexerCodeBlock)codeBlock2;
                        ImmutableSeq<HighlightInfo.Lit> highlights = SyntaxHighlight.lexicalHighlight(new SourceFile("aya-lexer", Option.none(), code.code));
                        code.highlighted = this.doHighlight(StringSlice.of((String)code.code), 0, highlights);
                        break;
                    }
                }
            }
        }
        super.accept(literate);
    }

    @NotNull
    private static ImmutableSeq<HighlightInfo> merge(@NotNull SourcePos codeRange, @NotNull PrettierOptions options, @NotNull ImmutableSeq<HighlightInfo> highlights, @NotNull ImmutableSeq<Problem> problems) {
        ImmutableSeq problemsInRange = problems.view().filter(p -> codeRange.containsIndex(p.sourcePos())).flatMap(p -> InlineHintProblem.withInlineHints(p, options)).distinct().toImmutableSeq();
        return (ImmutableSeq)problemsInRange.foldLeft(FaithfulPrettier.highlightsInRange(codeRange, highlights), (acc, p) -> {
            Tuple2 partition = acc.partition(h -> p.sourcePos().containsIndex(h.sourcePos()));
            ImmutableSeq inP = ((ImmutableSeq)partition.component1()).sorted();
            HighlightInfo.Err wrap = new HighlightInfo.Err((Problem)p, (ImmutableSeq<HighlightInfo>)inP);
            return ((ImmutableSeq)partition.component2()).appended((Object)wrap);
        });
    }

    @NotNull
    public Doc highlight(@NotNull String raw, @NotNull SourcePos codeRange) {
        ImmutableSeq merged = LiterateFaithfulPrettier.merge(codeRange, this.options(), this.highlights, this.problems).sorted();
        FaithfulPrettier.checkHighlights((ImmutableSeq<HighlightInfo>)merged);
        return this.doHighlight(StringSlice.of((String)raw), codeRange.tokenStartIndex(), merged);
    }
}

