/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.aya.cli.literate.AttrWarn;
import org.aya.literate.Literate;
import org.aya.literate.LiterateConsumer;
import org.aya.literate.parser.BaseMdParser;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.syntax.literate.AyaBacktickParser;
import org.aya.syntax.literate.AyaLiterate;
import org.aya.syntax.literate.CodeOptions;
import org.aya.util.error.SourceFile;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.jetbrains.annotations.NotNull;

public class AyaMdParser
extends BaseMdParser {
    public AyaMdParser(@NotNull SourceFile file, @NotNull Reporter reporter) {
        super(file, reporter, AyaLiterate.LANGUAGES);
        int index = this.sequentialParsers.indexWhere(parser -> parser instanceof BacktickParser);
        this.sequentialParsers.set(index, (Object)new AyaBacktickParser());
    }

    protected void addProviders(ArrayList<MarkerBlockProvider<MarkerProcessor.StateInfo>> providers) {
        super.addProviders(providers);
    }

    @NotNull
    public String extractAya(@NotNull Literate literate) {
        return this.etching(new LiterateConsumer.InstanceExtractinator(AyaLiterate.AyaCodeBlock.class).extract(literate).view().map(Function.identity()));
    }

    @NotNull
    protected Literate mapNode(@NotNull ASTNode node) {
        if (node.getType() == AyaBacktickParser.AYA_CODE_SPAN) {
            ASTNode attrSet = (ASTNode)node.getChildren().getLast();
            BaseMdParser.StripSurrounding code = new BaseMdParser.StripSurrounding((BaseMdParser)this, (ASTNode)node.getChildren().getFirst(), 1, 1);
            assert (attrSet.getType() == AyaBacktickParser.ATTR_SET);
            CodeOptions attr = this.parseAttrSet(attrSet);
            return new AyaLiterate.AyaInlineCode(code.literal(), Objects.requireNonNull(code.sourcePos()), attr);
        }
        return super.mapNode(node);
    }

    @NotNull
    public CodeOptions parseAttrSet(ASTNode attrSet) {
        AyaPrettierOptions dist = new AyaPrettierOptions();
        CodeOptions.NormalizeMode mode = CodeOptions.NormalizeMode.NULL;
        CodeOptions.ShowCode show = CodeOptions.ShowCode.Core;
        for (ASTNode attr : attrSet.getChildren()) {
            if (attr.getType() != AyaBacktickParser.ATTR) continue;
            String key = this.getTextInNode((ASTNode)attr.getChildren().getFirst());
            String value = this.getTextInNode((ASTNode)attr.getChildren().get(attr.getChildren().size() - 2));
            if ("mode".equalsIgnoreCase(key)) {
                mode = (CodeOptions.NormalizeMode)this.cbt(attr, value, (Enum[])CodeOptions.NormalizeMode.values(), (Enum)CodeOptions.NormalizeMode.NULL);
                continue;
            }
            if ("show".equalsIgnoreCase(key)) {
                show = (CodeOptions.ShowCode)this.cbt(attr, value, (Enum[])CodeOptions.ShowCode.values(), (Enum)CodeOptions.ShowCode.Core);
                continue;
            }
            AyaPrettierOptions.Key cbt = (AyaPrettierOptions.Key)this.cbt(attr, key, (Enum[])AyaPrettierOptions.Key.values(), null);
            if (cbt != null) {
                boolean isTrue = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
                dist.map.put(cbt, isTrue);
                continue;
            }
            this.reporter.report((Problem)new AttrWarn.UnknownKey(this.fromNode(attr), key));
        }
        return new CodeOptions(mode, (PrettierOptions)dist, show);
    }

    private <E extends Enum<E>> E cbt(@NotNull ASTNode attr, @NotNull String userVal, E[] values, E otherwise) {
        for (E val : values) {
            if (!StringUtil.containsIgnoreCase((String)((Enum)val).name(), (String)userVal)) continue;
            return val;
        }
        this.reporter.report((Problem)new AttrWarn.UnknownValue(this.fromNode(attr), userVal, (Enum<?>[])values));
        return otherwise;
    }
}

