/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.source;

import java.io.IOException;
import java.nio.file.Path;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.json.LibraryConfig;
import org.aya.cli.library.json.LibraryConfigData;
import org.aya.cli.library.json.LibraryDependency;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.library.source.MutableLibraryOwner;
import org.aya.syntax.AyaFiles;
import org.aya.util.error.SourceFileLocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DiskLibraryOwner(@NotNull SourceFileLocator locator, @NotNull MutableList<Path> modulePathMut, @NotNull MutableList<LibraryOwner> libraryDepsMut, @NotNull MutableList<LibrarySource> librarySourcesMut, @NotNull LibraryConfig underlyingLibrary) implements MutableLibraryOwner
{
    @Nullable
    private static LibraryConfig depConfig(@NotNull LibraryConfig config, @NotNull LibraryDependency dep) throws IOException {
        if (dep instanceof LibraryDependency.DepFile) {
            LibraryDependency.DepFile file = (LibraryDependency.DepFile)dep;
            return LibraryConfigData.fromDependencyRoot(file.depRoot(), config.literateConfig(), version -> DiskLibraryOwner.depBuildRoot(config, dep.depName(), version));
        }
        return null;
    }

    @NotNull
    private static Path depBuildRoot(@NotNull LibraryConfig config, @NotNull String depName, @NotNull String version) {
        return config.libraryBuildRoot().resolve("deps").resolve(depName + "_" + version);
    }

    @NotNull
    public static DiskLibraryOwner from(@NotNull LibraryConfig config) throws IOException {
        Path srcRoot = config.librarySrcRoot();
        SourceFileLocator.Module locator = new SourceFileLocator.Module((SeqLike)SeqView.of((Object)srcRoot));
        DiskLibraryOwner owner = new DiskLibraryOwner((SourceFileLocator)locator, (MutableList<Path>)MutableList.of((Object)srcRoot), (MutableList<LibraryOwner>)MutableList.create(), (MutableList<LibrarySource>)MutableList.create(), config);
        owner.librarySourcesMut.appendAll((Iterable)AyaFiles.collectAyaSourceFiles((Path)srcRoot).map(p -> LibrarySource.create(owner, p)));
        for (LibraryDependency dep : config.deps()) {
            LibraryConfig depConfig = DiskLibraryOwner.depConfig(config, dep);
            if (depConfig == null) continue;
            DiskLibraryOwner depCompiler = DiskLibraryOwner.from(depConfig);
            owner.libraryDepsMut.append((Object)depCompiler);
        }
        return owner;
    }
}

