/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.incremental;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.module.ModuleLoader;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryCompilerAdvisor
implements CompilerAdvisor {
    @NotNull
    protected final MutableMap<Path, FileTime> coreTimestamp = MutableMap.create();
    @NotNull
    protected final MutableMap<ModulePath, ResolveInfo> compiledCore = MutableMap.create();

    @NotNull
    protected Path timestampKey(@NotNull LibrarySource source) {
        return source.underlyingFile();
    }

    @Override
    public boolean isSourceModified(@NotNull LibrarySource source) {
        Option coreLastModified = this.coreTimestamp.getOption((Object)this.timestampKey(source));
        try {
            if (coreLastModified.isEmpty()) {
                return true;
            }
            return Files.getLastModifiedTime(this.timestampKey(source), new LinkOption[0]).compareTo((FileTime)coreLastModified.get()) > 0;
        }
        catch (IOException ignore) {
            return true;
        }
    }

    @Override
    public void updateLastModified(@NotNull LibrarySource source) {
        try {
            this.coreTimestamp.put((Object)this.timestampKey(source), (Object)Files.getLastModifiedTime(this.timestampKey(source), new LinkOption[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void prepareLibraryOutput(@NotNull LibraryOwner owner) {
    }

    @Override
    public void clearLibraryOutput(@NotNull LibraryOwner owner) {
        owner.librarySources().forEach(src -> {
            this.coreTimestamp.remove((Object)this.timestampKey((LibrarySource)src));
            this.clearModuleOutput((LibrarySource)src);
        });
    }

    @Override
    public void clearModuleOutput(@NotNull LibrarySource source) {
        this.compiledCore.remove((Object)source.moduleName());
    }

    @Override
    @Nullable
    public ResolveInfo doLoadCompiledCore(@NotNull Reporter reporter, @NotNull LibraryOwner owner, @NotNull ModulePath mod, @Nullable Path sourcePath, @Nullable Path corePath, @NotNull ModuleLoader recurseLoader) {
        return (ResolveInfo)this.compiledCore.getOrNull((Object)mod);
    }

    @Override
    @NotNull
    public ResolveInfo doSaveCompiledCore(@NotNull LibrarySource file, @NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<TyckDef> defs, @NotNull ModuleLoader recurseLoader) {
        this.compiledCore.put((Object)file.moduleName(), (Object)resolveInfo);
        return resolveInfo;
    }
}

