/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.incremental;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.utils.CompilerUtil;
import org.aya.compiler.CompiledModule;
import org.aya.compiler.serializers.ModuleSerializer;
import org.aya.compiler.serializers.NameSerializer;
import org.aya.primitive.PrimFactory;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.module.ModuleLoader;
import org.aya.syntax.core.def.TopLevelDef;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.ref.ModulePath;
import org.aya.syntax.ref.QPath;
import org.aya.util.FileUtil;
import org.aya.util.error.Global;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiskCompilerAdvisor
implements CompilerAdvisor {
    private final AyaClassLoader cl = new AyaClassLoader();

    @Override
    public void close() throws Exception {
        this.cl.close();
    }

    @Override
    public boolean isSourceModified(@NotNull LibrarySource source) {
        try {
            Path core = source.compiledCorePath();
            if (!Files.exists(core, new LinkOption[0])) {
                return true;
            }
            return Files.getLastModifiedTime(source.underlyingFile(), new LinkOption[0]).compareTo(Files.getLastModifiedTime(core, new LinkOption[0])) > 0;
        }
        catch (IOException ignore) {
            return true;
        }
    }

    @Override
    public void updateLastModified(@NotNull LibrarySource source) {
        try {
            Path core = source.compiledCorePath();
            Files.setLastModifiedTime(core, Files.getLastModifiedTime(source.underlyingFile(), new LinkOption[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void prepareLibraryOutput(@NotNull LibraryOwner owner) throws IOException {
        Files.createDirectories(owner.outDir(), new FileAttribute[0]);
    }

    @Override
    public void clearLibraryOutput(@NotNull LibraryOwner owner) throws IOException {
        FileUtil.deleteRecursively((Path)owner.outDir());
    }

    @Override
    public void clearModuleOutput(@NotNull LibrarySource source) throws IOException {
        Files.deleteIfExists(source.compiledCorePath());
    }

    @NotNull
    private ResolveInfo doLoadCompiledCore(@NotNull CompiledModule compiledAya, @NotNull Reporter reporter, @NotNull ModulePath mod, @NotNull Path sourcePath, @NotNull Path libraryRoot, @NotNull ModuleLoader recurseLoader, @NotNull PrimFactory primFactory) throws ClassNotFoundException, MalformedURLException {
        PhysicalModuleContext context = new EmptyContext(reporter, sourcePath).derive(mod);
        Path coreDir = DiskCompilerAdvisor.computeBaseDir(libraryRoot);
        this.cl.addURL(coreDir);
        this.cl.loadClass(NameSerializer.getModuleClassName((QPath)QPath.fileLevel((ModulePath)mod)));
        return compiledAya.toResolveInfo(recurseLoader, context, (ClassLoader)this.cl, primFactory);
    }

    @Override
    @Nullable
    public ResolveInfo doLoadCompiledCore(@NotNull Reporter reporter, @NotNull LibraryOwner owner, @NotNull ModulePath mod, @Nullable Path sourcePath, @Nullable Path corePath, @NotNull ModuleLoader recurseLoader) throws IOException, ClassNotFoundException {
        if (corePath == null || sourcePath == null) {
            return null;
        }
        if (!Files.exists(corePath, new LinkOption[0])) {
            return null;
        }
        try (ObjectInputStream inputStream = FileUtil.ois((Path)corePath);){
            CompiledModule compiledAya = (CompiledModule)inputStream.readObject();
            int parentCount = mod.size();
            Path libraryRoot = corePath;
            for (int i = 0; i < parentCount; ++i) {
                libraryRoot = libraryRoot.getParent();
            }
            ResolveInfo resolveInfo = this.doLoadCompiledCore(compiledAya, reporter, mod, sourcePath, libraryRoot, recurseLoader, new PrimFactory());
            return resolveInfo;
        }
    }

    @Override
    @NotNull
    public ResolveInfo doSaveCompiledCore(@NotNull LibrarySource file, @NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<TyckDef> defs, @NotNull ModuleLoader recurseLoader) throws IOException, ClassNotFoundException {
        String javaCode = new ModuleSerializer(resolveInfo.shapeFactory()).serializeWithBestBuilder(new ModuleSerializer.ModuleResult(QPath.fileLevel((ModulePath)file.moduleName()), defs.filterIsInstance(TopLevelDef.class)));
        Path libraryRoot = file.owner().outDir();
        Path baseDir = DiskCompilerAdvisor.computeBaseDir(libraryRoot).toAbsolutePath();
        String relativePath = NameSerializer.getReference((QPath)QPath.fileLevel((ModulePath)file.moduleName()), null, (NameSerializer.NameType)NameSerializer.NameType.ClassPath) + ".java";
        Path javaSrcPath = baseDir.resolve(relativePath);
        FileUtil.writeString((Path)javaSrcPath, (String)javaCode);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, StandardCharsets.UTF_8);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjects(javaSrcPath);
        SeqView classpath = this.cl.urls.view().appended((Object)baseDir).map(Path::toString);
        String selfClassPath = System.getProperty("java.class.path");
        if (selfClassPath != null && !selfClassPath.isBlank()) {
            classpath = classpath.appended((Object)selfClassPath);
        } else {
            Path jlinkClassPath = Paths.get(System.getProperty("jdk.module.path"), new String[0]).resolveSibling("misc").resolve("syntax-fat.jar").normalize();
            classpath = classpath.appended((Object)jlinkClassPath.toString());
        }
        List<String> options = List.of("--class-path", classpath.joinToString((CharSequence)File.pathSeparator), "--enable-preview", "--release", "22");
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, options, null, compilationUnits);
        boolean compileSuccess = task.call();
        if (Global.DELETE_JIT_JAVA_SOURCE && compileSuccess) {
            Files.delete(javaSrcPath);
        }
        Path coreFile = file.compiledCorePath();
        CompiledModule coreMod = CompilerUtil.saveCompiledCore(coreFile, defs, resolveInfo);
        return this.doLoadCompiledCore(coreMod, resolveInfo.reporter(), resolveInfo.modulePath(), file.underlyingFile(), libraryRoot, recurseLoader, resolveInfo.primFactory());
    }

    @NotNull
    private static Path computeBaseDir(@NotNull Path outDir) {
        return outDir.resolve("compiled");
    }

    private static class AyaClassLoader
    extends URLClassLoader {
        public MutableList<Path> urls = MutableList.create();

        public AyaClassLoader() {
            super(new URL[0], DiskCompilerAdvisor.class.getClassLoader());
        }

        public void addURL(Path url) throws MalformedURLException {
            this.addURL(url.toUri().toURL());
            this.urls.append((Object)url);
        }
    }
}

