/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.incremental;

import java.io.IOException;
import java.nio.file.Path;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.incremental.DiskCompilerAdvisor;
import org.aya.cli.library.incremental.InMemoryCompilerAdvisor;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.producer.AyaParserImpl;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.module.CachedModuleLoader;
import org.aya.resolve.module.ModuleLoader;
import org.aya.syntax.GenericAyaParser;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.error.Panic;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CompilerAdvisor
extends AutoCloseable {
    @NotNull
    public static CompilerAdvisor onDisk() {
        return new DiskCompilerAdvisor();
    }

    @NotNull
    public static CompilerAdvisor inMemory() {
        return new InMemoryCompilerAdvisor();
    }

    public boolean isSourceModified(@NotNull LibrarySource var1);

    public void updateLastModified(@NotNull LibrarySource var1);

    public void prepareLibraryOutput(@NotNull LibraryOwner var1) throws IOException;

    public void clearLibraryOutput(@NotNull LibraryOwner var1) throws IOException;

    public void clearModuleOutput(@NotNull LibrarySource var1) throws IOException;

    @NotNull
    default public GenericAyaParser createParser(@NotNull Reporter reporter) {
        return new AyaParserImpl(reporter);
    }

    default public void notifyIncrementalJob(@NotNull ImmutableSeq<LibrarySource> modified, @NotNull ImmutableSeq<ImmutableSeq<LibrarySource>> affected) {
    }

    @Nullable
    public ResolveInfo doLoadCompiledCore(@NotNull Reporter var1, @NotNull LibraryOwner var2, @NotNull ModulePath var3, @Nullable Path var4, @Nullable Path var5, @NotNull ModuleLoader var6) throws IOException, ClassNotFoundException;

    @NotNull
    public ResolveInfo doSaveCompiledCore(@NotNull LibrarySource var1, @NotNull ResolveInfo var2, @NotNull ImmutableSeq<TyckDef> var3, @NotNull ModuleLoader var4) throws IOException, ClassNotFoundException;

    @ApiStatus.NonExtendable
    @Nullable
    default public ResolveInfo loadCompiledCore(@NotNull Reporter reporter, @NotNull LibraryOwner owner, @NotNull ModulePath mod, @Nullable Path sourcePath, @Nullable Path corePath, @NotNull ModuleLoader recurseLoader) {
        if (!1.$assertionsDisabled && !(recurseLoader instanceof CachedModuleLoader)) {
            throw new AssertionError();
        }
        try {
            return this.doLoadCompiledCore(reporter, owner, mod, sourcePath, corePath, recurseLoader);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new Panic("Compiled aya found but cannot be loaded", (Throwable)e);
        }
    }

    @ApiStatus.NonExtendable
    @NotNull
    default public ResolveInfo saveCompiledCore(@NotNull LibrarySource file, @NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<TyckDef> defs, @NotNull ModuleLoader recurseLoader) {
        if (!1.$assertionsDisabled && !(recurseLoader instanceof CachedModuleLoader)) {
            throw new AssertionError();
        }
        try {
            ResolveInfo info = this.doSaveCompiledCore(file, resolveInfo, defs, recurseLoader);
            this.updateLastModified(file);
            return info;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return resolveInfo;
        }
    }

    @Override
    default public void close() throws Exception {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

