/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.primitive.PrimFactory;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.module.ModuleLoader;
import org.aya.syntax.AyaFiles;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LibraryModuleLoader
extends Record
implements ModuleLoader {
    @NotNull
    private final CountingReporter reporter;
    @NotNull
    private final LibraryOwner owner;
    @NotNull
    private final CompilerAdvisor advisor;
    @NotNull
    private final United states;

    LibraryModuleLoader(@NotNull CountingReporter reporter, @NotNull LibraryOwner owner, @NotNull CompilerAdvisor advisor, @NotNull United states) {
        this.reporter = reporter;
        this.owner = owner;
        this.advisor = advisor;
        this.states = states;
    }

    @NotNull
    public ResolveInfo load(@NotNull ModulePath mod, @NotNull ModuleLoader recurseLoader) {
        SeqView<Path> basePaths = this.owner.modulePath();
        Path sourcePath = AyaFiles.resolveAyaSourceFile(basePaths, (ImmutableSeq)mod.module());
        if (sourcePath == null) {
            Path depCorePath = AyaFiles.resolveAyaCompiledFile(basePaths, (ImmutableSeq)mod.module());
            ResolveInfo core = this.loadCompiledCore(mod, depCorePath, depCorePath, recurseLoader);
            assert (core != null) : "dependencies not built?";
            return core;
        }
        LibrarySource source = this.owner.findModule(mod);
        assert (source != null);
        Path corePath = source.compiledCorePath();
        ResolveInfo tryCore = this.loadCompiledCore(mod, sourcePath, corePath, recurseLoader);
        if (tryCore != null) {
            source.resolveInfo().set((Object)tryCore);
            return tryCore;
        }
        ImmutableSeq program = (ImmutableSeq)source.program().get();
        assert (program != null);
        PhysicalModuleContext context = new EmptyContext((Reporter)this.reporter, sourcePath).derive(mod);
        ResolveInfo resolveInfo = this.resolveModule(this.states.primFactory, (ModuleContext)context, program, recurseLoader);
        this.tyckModule(resolveInfo, (moduleResolve, defs) -> {
            source.notifyTycked(moduleResolve, (ImmutableSeq<TyckDef>)defs);
            if (this.reporter.noError()) {
                this.saveCompiledCore(source, moduleResolve, (ImmutableSeq<TyckDef>)defs, recurseLoader);
            }
        });
        ResolveInfo tyckedInfo = (ResolveInfo)source.resolveInfo().get();
        if (tyckedInfo == null) {
            tyckedInfo = resolveInfo;
        }
        return tyckedInfo;
    }

    public boolean existsFileLevelModule(@NotNull ModulePath path) {
        return this.owner.findModule(path) != null;
    }

    @Nullable
    private ResolveInfo loadCompiledCore(@NotNull ModulePath mod, @Nullable Path sourcePath, @Nullable Path corePath, @NotNull ModuleLoader recurseLoader) {
        return this.advisor.loadCompiledCore((Reporter)this.reporter, this.owner, mod, sourcePath, corePath, recurseLoader);
    }

    private void saveCompiledCore(@NotNull LibrarySource file, @NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<TyckDef> defs, @NotNull ModuleLoader recurseLoader) {
        ResolveInfo info = this.advisor.saveCompiledCore(file, resolveInfo, defs, recurseLoader);
        file.resolveInfo().set((Object)info);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LibraryModuleLoader.class, "reporter;owner;advisor;states", "reporter", "owner", "advisor", "states"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LibraryModuleLoader.class, "reporter;owner;advisor;states", "reporter", "owner", "advisor", "states"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LibraryModuleLoader.class, "reporter;owner;advisor;states", "reporter", "owner", "advisor", "states"}, this, o);
    }

    @NotNull
    public CountingReporter reporter() {
        return this.reporter;
    }

    @NotNull
    public LibraryOwner owner() {
        return this.owner;
    }

    @NotNull
    public CompilerAdvisor advisor() {
        return this.advisor;
    }

    @NotNull
    public United states() {
        return this.states;
    }

    record United(@NotNull PrimFactory primFactory) {
    }
}

