/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.interactive;

import kala.collection.MapLike;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedSet;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.tuple.Tuple2;
import org.aya.resolve.context.Candidate;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleExport;
import org.aya.resolve.context.ModuleSymbol;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.ref.AnyDefVar;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.RepoLike;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplContext
extends PhysicalModuleContext
implements RepoLike<ReplContext> {
    @Nullable
    private ReplContext downstream = null;
    private boolean modified = true;
    @Nullable
    private ImmutableMap<String, ModuleTrie> moduleTree = null;

    public ReplContext(@NotNull Reporter reporter, @NotNull Context parent, @NotNull ModulePath name) {
        super(reporter, parent, name);
    }

    public void importSymbol(@NotNull AnyVar ref, @NotNull ModuleName fromModule, @NotNull String name, @NotNull Stmt.Accessibility acc, @NotNull SourcePos sourcePos) {
        this.modified = true;
        this.symbols().add(name, (Object)ref, fromModule);
        if (ref instanceof DefVar) {
            DefVar defVar = (DefVar)ref;
            if (acc == Stmt.Accessibility.Public) {
                this.exportSymbol(name, (AnyDefVar)defVar);
            }
        }
    }

    public boolean exportSymbol(@NotNull String name, @NotNull AnyDefVar ref) {
        super.exportSymbol(name, ref);
        return true;
    }

    public void importModule(@NotNull ModuleName.Qualified modName, @NotNull ModuleExport mod, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos) {
        this.modified = true;
        this.modules.put((Object)modName, (Object)mod);
        if (accessibility == Stmt.Accessibility.Public) {
            this.exports.export(modName, mod);
        }
    }

    @NotNull
    public ReplContext derive(@NotNull ModulePath extraName, @NotNull Reporter reporter) {
        return new ReplContext(reporter, (Context)this, this.modulePath().derive(extraName));
    }

    @NotNull
    public ReplContext derive(@NotNull String extraName, @NotNull Reporter reporter) {
        return new ReplContext(reporter, (Context)this, this.modulePath().derive(extraName));
    }

    public void setDownstream(@Nullable ReplContext downstream) {
        this.downstream = downstream;
    }

    @NotNull
    public ReplContext fork() {
        ReplContext kid = this.derive(":theKid", this.reporter);
        this.fork((Object)kid);
        return kid;
    }

    public void merge() {
        ReplContext bors = this.downstream;
        super.merge();
        if (bors == null) {
            return;
        }
        this.modified = true;
        ReplContext.mergeSymbols(this.symbols, bors.symbols);
        this.exports.symbols().putAll((MapLike)bors.exports.symbols());
        this.exports.modules().putAll((MapLike)bors.exports.modules());
        this.modules.putAll((MapLike)bors.modules);
    }

    @Contract(mutates="this")
    public void clear() {
        this.modified = true;
        this.modules.clear();
        this.exports.symbols().clear();
        this.exports.modules().clear();
        this.symbols.table().clear();
    }

    private static <T> void mergeSymbols(@NotNull ModuleSymbol<T> dest, @NotNull ModuleSymbol<T> src) {
        for (String key : src.table().keysView()) {
            Candidate candy = dest.get(key);
            dest.table().put((Object)key, (Object)candy.merge(src.get(key)));
        }
    }

    @Nullable
    private ModuleTrie resolve(@NotNull ImmutableSeq<String> path) {
        SeqView pathView = path.view();
        ModuleTrie tree = new ModuleTrie(this.moduleTree(), false);
        while (pathView.isNotEmpty() && tree != null) {
            String head = (String)pathView.getFirst();
            SeqView tail = pathView.drop(1);
            tree = (ModuleTrie)tree.children().getOrNull((Object)head);
            pathView = tail;
        }
        return tree;
    }

    @NotNull
    public ImmutableSeq<String> giveMeHint(@NotNull ImmutableSeq<String> prefix) {
        ModuleTrie node = this.resolve(prefix);
        if (node == null) {
            return ImmutableSeq.empty();
        }
        MutableLinkedSet hint = MutableLinkedSet.create();
        hint.addAll((Iterable)node.children().keysView());
        if (node.inhabited) {
            ModuleExport mod = this.getModuleMaybe(new ModuleName.Qualified(prefix));
            assert (mod != null);
            hint.addAll((Iterable)mod.symbols().keysView());
        }
        return hint.toImmutableSeq();
    }

    @NotNull
    public ImmutableMap<String, ModuleTrie> moduleTree() {
        if (!this.modified) {
            assert (this.moduleTree != null);
            return this.moduleTree;
        }
        ImmutableSeq moduleNames = this.modules.keysView().toImmutableSeq().map(x -> x.ids().view());
        this.moduleTree = this.buildModuleTree((Seq<SeqView<String>>)moduleNames);
        this.modified = false;
        return this.moduleTree;
    }

    @NotNull
    private ImmutableMap<String, ModuleTrie> buildModuleTree(@NotNull Seq<SeqView<String>> moduleNames) {
        if (moduleNames.isEmpty()) {
            return ImmutableMap.empty();
        }
        MutableMap indexed = MutableMap.create();
        MutableSet inhabited = MutableSet.create();
        for (SeqView name : moduleNames) {
            String head = (String)name.getFirst();
            SeqView tail = name.drop(1);
            MutableList root = (MutableList)indexed.getOrPut((Object)head, MutableList::create);
            if (tail.isNotEmpty()) {
                root.append((Object)tail);
                continue;
            }
            inhabited.add((Object)head);
        }
        return (ImmutableMap)indexed.toImmutableSeq().collect(ImmutableMap.collector(Tuple2::component1, x -> {
            ImmutableMap<String, ModuleTrie> children = this.buildModuleTree((Seq<SeqView<String>>)((Seq)x.component2()));
            boolean isInhabited = inhabited.contains(x.component1());
            return new ModuleTrie(children, isInhabited);
        }));
    }

    public record ModuleTrie(@NotNull ImmutableMap<String, ModuleTrie> children, boolean inhabited) {
    }
}

