/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.interactive;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Either;
import kala.function.CheckedFunction;
import kala.value.MutableValue;
import org.aya.cli.interactive.ReplContext;
import org.aya.cli.interactive.ReplShapeFactory;
import org.aya.cli.library.LibraryCompiler;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.json.LibraryConfigData;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.single.CompilerFlags;
import org.aya.cli.single.SingleAyaFile;
import org.aya.cli.utils.LiterateData;
import org.aya.generic.InterruptException;
import org.aya.normalize.Normalizer;
import org.aya.primitive.PrimFactory;
import org.aya.primitive.ShapeFactory;
import org.aya.producer.AyaParserImpl;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.module.CachedModuleLoader;
import org.aya.resolve.module.FileModuleLoader;
import org.aya.resolve.module.ModuleListLoader;
import org.aya.resolve.module.ModuleLoader;
import org.aya.resolve.salt.AyaBinOpSet;
import org.aya.resolve.salt.Desalt;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.syntax.GenericAyaFile;
import org.aya.syntax.GenericAyaParser;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.core.Jdg;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.literate.CodeOptions;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.TyckState;
import org.aya.tyck.tycker.TeleTycker;
import org.aya.util.error.PosedUnaryOperator;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.DelayedReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplCompiler {
    @NotNull
    public final CountingReporter reporter;
    @NotNull
    public final ImmutableSeq<Path> modulePaths;
    @NotNull
    public final MutableList<ResolveInfo> imports = MutableList.create();
    @NotNull
    private final SourceFileLocator locator;
    @NotNull
    private final CachedModuleLoader<ModuleListLoader> loader;
    @NotNull
    private final ReplContext context;
    @NotNull
    private final PrimFactory primFactory;
    @NotNull
    private final ReplShapeFactory shapeFactory;
    @NotNull
    private final GenericAyaFile.Factory fileManager;
    @NotNull
    private final AyaBinOpSet opSet;
    @NotNull
    private final TyckState tcState;

    public ReplCompiler(@NotNull ImmutableSeq<Path> modulePaths, @NotNull Reporter delegateReporter, @Nullable SourceFileLocator locator) {
        this.modulePaths = modulePaths;
        this.reporter = CountingReporter.delegate((Reporter)delegateReporter);
        this.locator = locator != null ? locator : new SourceFileLocator.Module(this.modulePaths);
        this.primFactory = new PrimFactory(this){

            public boolean isForbiddenRedefinition(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull PrimDef.ID id, boolean isJit) {
                return false;
            }
        };
        this.shapeFactory = new ReplShapeFactory();
        this.opSet = new AyaBinOpSet((Reporter)this.reporter);
        this.context = new ReplContext((Reporter)this.reporter, (Context)new EmptyContext((Reporter)this.reporter, Path.of("REPL", new String[0])), ModulePath.of((String[])new String[]{"REPL"}));
        this.fileManager = new SingleAyaFile.Factory((Reporter)this.reporter);
        AyaParserImpl parser = new AyaParserImpl((Reporter)this.reporter);
        this.loader = new CachedModuleLoader((ModuleLoader)new ModuleListLoader((Reporter)this.reporter, this.modulePaths.map(path -> new FileModuleLoader(this.locator, path, (Reporter)this.reporter, (GenericAyaParser)parser, this.fileManager, this.primFactory))));
        this.tcState = new TyckState((ShapeFactory)this.shapeFactory, this.primFactory);
    }

    @NotNull
    private ExprResolver.LiterateResolved desugarExpr(@NotNull ExprResolver.LiterateResolved expr, @NotNull Reporter reporter) {
        PhysicalModuleContext ctx = new EmptyContext(reporter, Path.of("dummy", new String[0])).derive("dummy");
        ResolveInfo resolveInfo = this.makeResolveInfo((ModuleContext)ctx);
        return expr.descent((PosedUnaryOperator)new Desalt(resolveInfo));
    }

    public void loadToContext(@NotNull Path file) throws IOException {
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.loadLibrary(file);
        } else {
            this.loadFile(file);
        }
    }

    private void loadLibrary(@NotNull Path libraryRoot) throws IOException {
        CompilerFlags flags = new CompilerFlags(CompilerFlags.Message.EMOJI, false, true, null, (SeqView<Path>)this.modulePaths.view(), null);
        try {
            LibraryCompiler compiler = LibraryCompiler.newCompiler(this.primFactory, (Reporter)this.reporter, flags, CompilerAdvisor.onDisk(), libraryRoot);
            compiler.start();
            this.importModule(compiler.libraryOwner());
        }
        catch (LibraryConfigData.BadConfig bad) {
            this.reporter.reportString("Cannot load malformed library: " + bad.getMessage(), Problem.Severity.ERROR);
        }
    }

    private void importModule(@NotNull LibraryOwner owner) {
        owner.librarySources().map(src -> {
            ResolveInfo info = (ResolveInfo)src.resolveInfo().get();
            this.imports.append((Object)info);
            return info.thisModule();
        }).filterIsInstance(PhysicalModuleContext.class).forEach(mod -> this.context.importModuleContext(mod.modulePath().asName(), (ModuleContext)mod, Stmt.Accessibility.Public, SourcePos.NONE));
        owner.libraryDeps().forEach(this::importModule);
    }

    private void loadFile(@NotNull Path file) {
        this.compileToContext((CheckedFunction<AyaParserImpl, Either<ImmutableSeq<Stmt>, WithPos<Expr>>, IOException>)((CheckedFunction)parser -> Either.left((Object)this.fileManager.createAyaFile(this.locator, file).parseMe((GenericAyaParser)parser))), CodeOptions.NormalizeMode.HEAD);
    }

    @NotNull
    public Either<ImmutableSeq<TyckDef>, Term> compileToContext(@NotNull String text, @NotNull CodeOptions.NormalizeMode normalizeMode) {
        if (text.isBlank()) {
            return Either.left((Object)ImmutableSeq.empty());
        }
        return this.compileToContext((CheckedFunction<AyaParserImpl, Either<ImmutableSeq<Stmt>, WithPos<Expr>>, IOException>)((CheckedFunction)parser -> parser.repl(text)), normalizeMode);
    }

    @NotNull
    public Either<ImmutableSeq<TyckDef>, Term> compileToContext(@NotNull CheckedFunction<AyaParserImpl, Either<ImmutableSeq<Stmt>, WithPos<Expr>>, IOException> parsing, @NotNull CodeOptions.NormalizeMode normalizeMode) {
        try {
            AyaParserImpl parser = new AyaParserImpl((Reporter)this.reporter);
            Either programOrExpr = (Either)parsing.applyChecked((Object)parser);
            return programOrExpr.map(program -> {
                MutableValue newDefs = MutableValue.create();
                ResolveInfo resolveInfo2 = this.makeResolveInfo((ModuleContext)this.context.fork());
                this.loader.resolveModule(resolveInfo2, program, this.loader);
                resolveInfo2.shapeFactory().discovered = this.shapeFactory.fork().discovered;
                this.loader.tyckModule(resolveInfo2, (resolveInfo, defs) -> newDefs.set((Object)defs));
                if (this.reporter.anyError()) {
                    return ImmutableSeq.empty();
                }
                this.context.merge();
                this.shapeFactory.merge();
                return (ImmutableSeq)newDefs.get();
            }, expr -> this.tyckAndNormalize((WithPos<Expr>)expr, false, normalizeMode));
        }
        catch (InterruptException parser) {
            return Either.left((Object)ImmutableSeq.empty());
        }
        catch (IOException e) {
            this.reporter.reportString(e.getMessage());
            return Either.left((Object)ImmutableSeq.empty());
        }
    }

    @NotNull
    private ResolveInfo makeResolveInfo(@NotNull ModuleContext ctx) {
        ResolveInfo resolveInfo = new ResolveInfo(ctx, this.primFactory, (ShapeFactory)this.shapeFactory, this.opSet);
        this.imports.forEach(ii -> resolveInfo.imports().put((Object)ii.modulePath().asName(), (Object)new ResolveInfo.ImportInfo(ii, false)));
        return resolveInfo;
    }

    @Nullable
    public AnyVar parseToAnyVar(@NotNull String text) {
        WithPos<Expr> parseTree = this.parseExpr(text);
        if (parseTree == null) {
            return null;
        }
        try {
            Object object = ExprResolver.resolveLax((ModuleContext)this.context, parseTree).expr().data();
            if (object instanceof Expr.Ref) {
                Expr.Ref unresolved = (Expr.Ref)object;
                return unresolved.var();
            }
        }
        catch (InterruptException interruptException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public Term computeType(@NotNull String text, CodeOptions.NormalizeMode mode) {
        try {
            WithPos<Expr> expr = this.parseExpr(text);
            if (expr == null) {
                return null;
            }
            return this.tyckAndNormalize(expr, true, mode);
        }
        catch (InterruptException interruptException) {
            return null;
        }
    }

    @Nullable
    private WithPos<Expr> parseExpr(@NotNull String text) {
        Either parseTree = new AyaParserImpl((Reporter)this.reporter).repl(text);
        if (parseTree.isLeft()) {
            this.reporter.reportString("Expect expression, got statement", Problem.Severity.ERROR);
            return null;
        }
        return (WithPos)parseTree.getRightValue();
    }

    @NotNull
    private Term tyckAndNormalize(WithPos<Expr> expr, boolean isType, CodeOptions.NormalizeMode mode) {
        Jdg jdg = null;
        ExprResolver.LiterateResolved resolvedExpr = ExprResolver.resolveLax((ModuleContext)this.context, expr);
        if (mode == CodeOptions.NormalizeMode.NULL) {
            jdg = LiterateData.simpleVar((Expr)resolvedExpr.expr().data());
        }
        if (jdg == null) {
            try (DelayedReporter delayedReporter = new DelayedReporter((Reporter)this.reporter);){
                this.tcState.clearTmp();
                ExprResolver.LiterateResolved desugar = this.desugarExpr(resolvedExpr, (Reporter)delayedReporter);
                TeleTycker.InlineCode tycker = new TeleTycker.InlineCode(new ExprTycker(this.tcState, (Reporter)delayedReporter, this.context.modulePath()));
                jdg = tycker.checkInlineCode(desugar.params(), desugar.expr());
            }
        }
        return new Normalizer(this.tcState).normalize(isType ? jdg.type() : jdg.wellTyped(), mode);
    }

    @NotNull
    public ReplContext getContext() {
        return this.context;
    }

    @NotNull
    public ShapeFactory getShapeFactory() {
        return this.shapeFactory;
    }

    public void loadPreludeIfPossible() {
        if (this.loader.existsFileLevelModule(ModulePath.of((String[])new String[]{"prelude"}))) {
            this.compileToContext("open import prelude", CodeOptions.NormalizeMode.NULL);
        }
    }
}

