/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.utils;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kala.collection.immutable.ImmutableSeq;
import kala.function.CheckedRunnable;
import org.aya.cli.single.CompilerFlags;
import org.aya.compiler.CompiledModule;
import org.aya.generic.InterruptException;
import org.aya.resolve.ResolveInfo;
import org.aya.syntax.core.def.TyckDef;
import org.aya.util.error.Panic;
import org.aya.util.reporter.CountingReporter;
import org.jetbrains.annotations.NotNull;

public class CompilerUtil {
    public static int catching(@NotNull CountingReporter reporter, @NotNull CompilerFlags flags, @NotNull CheckedRunnable<IOException> block) throws IOException {
        block4: {
            try {
                block.runChecked();
            }
            catch (Panic e) {
                CompilerUtil.handleInternalError(e);
                reporter.reportString("Internal error");
                return e.exitCode();
            }
            catch (InterruptException e) {
                reporter.reportString(e.stage().name() + " interrupted due to:");
                if (!flags.interruptedTrace()) break block4;
                e.printStackTrace();
            }
        }
        if (reporter.noError()) {
            reporter.reportString(flags.message().successNotation());
            return 0;
        }
        reporter.reportString(reporter.countToString());
        reporter.reportString(flags.message().failNotation());
        return 1;
    }

    public static void saveCompiledCore(@NotNull Path coreFile, @NotNull ImmutableSeq<TyckDef> defs, @NotNull ResolveInfo resolveInfo) throws IOException {
        CompiledModule compiledAya = CompiledModule.from((ResolveInfo)resolveInfo, defs);
        try (ObjectOutputStream outputStream = CompilerUtil.coreWriter(coreFile);){
            outputStream.writeObject(compiledAya);
        }
    }

    @NotNull
    private static ObjectOutputStream coreWriter(@NotNull Path coreFile) throws IOException {
        Files.createDirectories(coreFile.toAbsolutePath().getParent(), new FileAttribute[0]);
        return new ObjectOutputStream(Files.newOutputStream(coreFile, new OpenOption[0]));
    }

    public static void handleInternalError(@NotNull Panic e) {
        e.printStackTrace();
        e.printHint();
        System.err.println("Please report the stacktrace to the developers so a better error handling could be made.\nDon't forget to inform the version of Aya you're using and attach your code for reproduction.");
    }
}

