/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.single;

import java.nio.file.Path;
import kala.collection.SeqLike;
import org.aya.cli.render.RenderOptions;
import org.aya.cli.utils.CliEnums;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CompilerFlags(@NotNull Message message, boolean interruptedTrace, boolean remake, @Nullable PrettyInfo prettyInfo, @NotNull SeqLike<Path> modulePaths, @Nullable Path outputFile) {
    @Nullable
    public static PrettyInfo prettyInfoFromOutput(@Nullable Path outputFile, @NotNull RenderOptions renderOptions, boolean noCodeStyle, boolean inlineCodeStyle, boolean SSR) {
        if (outputFile != null) {
            return new PrettyInfo(false, noCodeStyle, inlineCodeStyle, SSR, CliEnums.PrettyStage.literate, CliEnums.detectFormat(outputFile), (PrettierOptions)AyaPrettierOptions.pretty(), renderOptions, null);
        }
        return null;
    }

    public record Message(@NotNull String successNotation, @NotNull String failNotation) {
        public static final Message EMOJI = new Message("\ud83c\udf89", "\ud83e\udd72");
        public static final Message ASCII = new Message("That looks right!", "Let's learn from that.");
    }

    public record PrettyInfo(boolean ascii, boolean prettyNoCodeStyle, boolean prettyInlineCodeStyle, boolean prettySSR, @NotNull CliEnums.PrettyStage prettyStage, @NotNull CliEnums.PrettyFormat prettyFormat, @NotNull PrettierOptions prettierOptions, @NotNull RenderOptions renderOptions, @Nullable String prettyDir) {
        @NotNull
        public RenderOptions.DefaultSetup backendOpts(boolean headerCode) {
            return new RenderOptions.DefaultSetup(headerCode, !this.prettyNoCodeStyle, !this.prettyInlineCodeStyle, !this.ascii, -1, this.prettySSR);
        }
    }
}

