/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import kala.value.LazyValue;
import org.aya.cli.literate.HighlightInfo;
import org.aya.generic.AyaDocile;
import org.aya.parser.AyaParserDefinitionBase;
import org.aya.parser.ParserDefBase;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Link;
import org.aya.producer.AyaProducer;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.Pattern;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.concrete.stmt.StmtVisitor;
import org.aya.syntax.concrete.stmt.decl.ClassDecl;
import org.aya.syntax.concrete.stmt.decl.ClassMember;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.concrete.stmt.decl.DataDecl;
import org.aya.syntax.concrete.stmt.decl.Decl;
import org.aya.syntax.concrete.stmt.decl.FnDecl;
import org.aya.syntax.concrete.stmt.decl.PrimDecl;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.ref.GeneralizedVar;
import org.aya.syntax.ref.GenerateKind;
import org.aya.syntax.ref.LocalVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.error.Panic;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SyntaxHighlight(@Nullable ModulePath currentFileModule, @NotNull MutableList<HighlightInfo> info) implements StmtVisitor
{
    @NotNull
    public static final TokenSet SPECIAL_SYMBOL = TokenSet.orSet((TokenSet[])new TokenSet[]{AyaParserDefinitionBase.UNICODES, AyaParserDefinitionBase.MARKERS, AyaParserDefinitionBase.DELIMITERS});

    @NotNull
    public static ImmutableSeq<HighlightInfo> highlight(@Nullable ModulePath currentFileModule, @NotNull Option<SourceFile> sourceFile, @NotNull ImmutableSeq<Stmt> program) {
        SyntaxHighlight prettier = new SyntaxHighlight(currentFileModule, (MutableList<HighlightInfo>)MutableList.create());
        program.forEach((Consumer)((Object)prettier));
        if (sourceFile.isDefined()) {
            SourceFile file = (SourceFile)sourceFile.get();
            FlexLexer lexer = AyaParserDefinitionBase.createLexer((boolean)false);
            lexer.reset((CharSequence)file.sourceCode(), 0, file.sourceCode().length(), 0);
            ImmutableSeq addition = lexer.allTheWayDown().view().mapNotNull(token -> {
                IElementType tokenType = token.type();
                if (AyaParserDefinitionBase.KEYWORDS.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf((FlexLexer.Token)token, (SourceFile)file), HighlightInfo.LitKind.Keyword);
                }
                if (ParserDefBase.COMMENTS.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf((FlexLexer.Token)token, (SourceFile)file), HighlightInfo.LitKind.Comment);
                }
                if (SPECIAL_SYMBOL.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf((FlexLexer.Token)token, (SourceFile)file), HighlightInfo.LitKind.SpecialSymbol);
                }
                if (tokenType == TokenType.WHITE_SPACE) {
                    String text = token.range().substring(file.sourceCode());
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf((FlexLexer.Token)token, (SourceFile)file), text.contains("\n") ? HighlightInfo.LitKind.Eol : HighlightInfo.LitKind.Whitespace);
                }
                return null;
            }).toImmutableSeq();
            prettier.info.appendAll((Iterable)addition);
        }
        return prettier.info.toImmutableSeq();
    }

    public void visitVarRef(@NotNull SourcePos pos, @NotNull AnyVar var, @NotNull LazyValue<@Nullable Term> type) {
        this.info.append((Object)this.linkRef(pos, var, (AyaDocile)type.get()));
    }

    public void visitExpr(@NotNull SourcePos pos, @NotNull Expr expr) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.LitInt.class, Expr.LitString.class, Expr.Hole.class}, (Object)expr3, n)) {
                case 0: {
                    this.info.append((Object)HighlightInfo.LitKind.Int.toLit(pos));
                    break block5;
                }
                case 1: {
                    this.info.append((Object)HighlightInfo.LitKind.String.toLit(pos));
                    break block5;
                }
                case 2: {
                    Expr.Hole hole = (Expr.Hole)expr3;
                    if (hole.filling() != null) {
                        n = 3;
                        continue block5;
                    }
                    Term hover = (Term)hole.solution().get();
                    if (hover == null) break block5;
                    this.info.append((Object)new HighlightInfo.UserMeta(pos, (AyaDocile)hover));
                    break block5;
                }
                default: {
                    super.visitExpr(pos, expr);
                    break block5;
                }
            }
            break;
        }
    }

    public void visitPattern(@NotNull SourcePos pos, @NotNull Pattern pat) {
        Pattern pattern = pat;
        Objects.requireNonNull(pattern);
        Pattern pattern2 = pattern;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Number.class}, (Object)pattern2, n)) {
            case 0: {
                this.info.append((Object)HighlightInfo.LitKind.Int.toLit(pos));
                break;
            }
            default: {
                super.visitPattern(pos, pat);
            }
        }
    }

    public void visitVarDecl(@NotNull SourcePos pos, @NotNull AnyVar var, @NotNull LazyValue<@Nullable Term> type) {
        LocalVar v;
        if (var instanceof LocalVar && (v = (LocalVar)var).isGenerated()) {
            return;
        }
        this.info.append((Object)this.linkDef(pos, var, (AyaDocile)type.get()));
    }

    public void visitModuleRef(@NotNull SourcePos pos, @NotNull ModulePath path) {
        Link link = this.currentFileModule != null && this.currentFileModule.sameElements(path) ? Link.loc((String)path.toString()) : Link.cross((ImmutableSeq)path.module(), null);
        this.info.append((Object)HighlightInfo.DefKind.Module.toRef(pos, link, null));
    }

    public void visitModuleRef(@NotNull SourcePos pos, @NotNull ModuleName path) {
        this.info.append((Object)HighlightInfo.DefKind.Module.toRef(pos, (Link)Link.loc((String)path.toString()), null));
    }

    public void visitModuleDecl(@NotNull SourcePos pos, @NotNull ModuleName path) {
        this.info.append((Object)HighlightInfo.DefKind.Module.toDef(pos, (Link)Link.loc((String)path.toString()), null));
    }

    @NotNull
    private HighlightInfo linkDef(@NotNull SourcePos sourcePos, @NotNull AnyVar var, @Nullable AyaDocile type) {
        return SyntaxHighlight.kindOf(var).toDef(sourcePos, BasePrettier.linkIdOf((ModulePath)this.currentFileModule, (AnyVar)var), type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private HighlightInfo linkRef(@NotNull SourcePos sourcePos, @NotNull AnyVar var, @Nullable AyaDocile type) {
        String string;
        if (!(var instanceof LocalVar)) return SyntaxHighlight.kindOf(var).toRef(sourcePos, BasePrettier.linkIdOf((ModulePath)this.currentFileModule, (AnyVar)var), type);
        LocalVar localVar = (LocalVar)var;
        try {
            string = localVar.name();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        string = localVar.definition();
        string = localVar.generateKind();
        if (!(string instanceof GenerateKind.Generalized)) return SyntaxHighlight.kindOf(var).toRef(sourcePos, BasePrettier.linkIdOf((ModulePath)this.currentFileModule, (AnyVar)var), type);
        GenerateKind.Generalized generalized = (GenerateKind.Generalized)string;
        String origin = string = generalized.origin();
        return this.linkRef(sourcePos, (AnyVar)origin, type);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static HighlightInfo.DefKind kindOf(@NotNull AnyVar var) {
        HighlightInfo.DefKind defKind;
        AnyVar anyVar = var;
        Objects.requireNonNull(anyVar);
        AnyVar anyVar2 = anyVar;
        int n = 0;
        block17: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, LocalVar.class, LocalVar.class}, (Object)anyVar2, n)) {
                case 0: {
                    defKind = HighlightInfo.DefKind.Generalized;
                    return defKind;
                }
                case 1: {
                    DefVar defVar = (DefVar)anyVar2;
                    Decl decl = defVar.concrete;
                    Objects.requireNonNull(decl);
                    LocalVar localVar = decl;
                    int n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FnDecl.class, ClassMember.class, DataDecl.class, DataCon.class, PrimDecl.class, ClassDecl.class}, (Object)localVar, n2)) {
                        case 0: {
                            defKind = HighlightInfo.DefKind.Fn;
                            return defKind;
                        }
                        case 1: {
                            defKind = HighlightInfo.DefKind.Member;
                            return defKind;
                        }
                        case 2: {
                            defKind = HighlightInfo.DefKind.Data;
                            return defKind;
                        }
                        case 3: {
                            defKind = HighlightInfo.DefKind.Con;
                            return defKind;
                        }
                        case 4: {
                            defKind = HighlightInfo.DefKind.Prim;
                            return defKind;
                        }
                        case 5: {
                            defKind = HighlightInfo.DefKind.Clazz;
                            return defKind;
                        }
                    }
                    throw new Panic("unknown def type: " + String.valueOf(defVar));
                }
                case 2: {
                    String string;
                    LocalVar localVar = (LocalVar)anyVar2;
                    try {
                        string = localVar.name();
                        string = localVar.definition();
                        string = localVar.generateKind();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (string instanceof GenerateKind.Generalized) {
                        GenerateKind.Generalized generalized = (GenerateKind.Generalized)string;
                        {
                            string = generalized.origin();
                        }
                    } else {
                        n = 3;
                        continue block17;
                    }
                    defKind = HighlightInfo.DefKind.Generalized;
                    return defKind;
                }
                case 3: {
                    defKind = HighlightInfo.DefKind.LocalVar;
                    return defKind;
                }
            }
            break;
        }
        defKind = HighlightInfo.DefKind.Unknown;
        return defKind;
    }
}

