/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import com.intellij.openapi.util.text.StringUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.text.StringSlice;
import org.aya.cli.literate.HighlightInfo;
import org.aya.generic.AyaDocile;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Language;
import org.aya.pretty.doc.Link;
import org.aya.pretty.doc.Style;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FaithfulPrettier {
    @NotNull
    public PrettierOptions options();

    public static void checkHighlights(@NotNull ImmutableSeq<HighlightInfo> highlights) {
        highlights.foldLeft((Object)-1, (lastEndIndex, h) -> {
            SourcePos sp = h.sourcePos();
            if (sp.tokenStartIndex() > sp.tokenEndIndex()) {
                throw new IllegalArgumentException("Invalid source pos: " + String.valueOf(sp));
            }
            if (lastEndIndex >= sp.tokenStartIndex()) {
                throw new IllegalArgumentException("Intersect with previous source pos: " + String.valueOf(sp));
            }
            return sp.tokenEndIndex();
        });
    }

    @NotNull
    public static ImmutableSeq<HighlightInfo> highlightsInRange(@NotNull SourcePos codeRange, @NotNull ImmutableSeq<HighlightInfo> highlights) {
        ImmutableSeq highlightInRange = highlights.view().filter(h -> h.sourcePos() != SourcePos.NONE).filterNot(h -> h.sourcePos().isEmpty()).filter(x -> codeRange.containsIndex(x.sourcePos())).sorted().distinct().toImmutableSeq();
        FaithfulPrettier.checkHighlights((ImmutableSeq<HighlightInfo>)highlightInRange);
        return highlightInRange;
    }

    @NotNull
    default public Doc doHighlight(@NotNull StringSlice raw, int base, @NotNull ImmutableSeq<HighlightInfo> highlights) {
        MutableList docs = MutableList.create();
        for (HighlightInfo current : highlights) {
            KnifeCut knifeCut = FaithfulPrettier.twoKnifeThreeParts(raw, base, current.sourcePos());
            if (!knifeCut.before.isEmpty()) {
                docs.append((Object)Doc.plain((String)knifeCut.before.toString()));
            }
            Doc highlight = this.highlightOne(knifeCut.current.toString(), base, current);
            docs.append((Object)highlight);
            raw = knifeCut.remaining;
            base = knifeCut.base;
        }
        if (!raw.isEmpty()) {
            docs.append((Object)Doc.plain((String)raw.toString()));
        }
        return Doc.cat((SeqLike)docs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Doc highlightOne(@NotNull String raw, int base, @NotNull HighlightInfo highlight) {
        Doc.Tooltip tooltip;
        if (raw.isEmpty()) {
            return Doc.empty();
        }
        HighlightInfo highlightInfo = highlight;
        Objects.requireNonNull(highlightInfo);
        HighlightInfo highlightInfo2 = highlightInfo;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HighlightInfo.Def.class, HighlightInfo.Ref.class, HighlightInfo.Lit.class, HighlightInfo.Err.class, HighlightInfo.UserMeta.class}, (Object)highlightInfo2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                HighlightInfo.Def def = (HighlightInfo.Def)highlightInfo2;
                tooltip = Doc.linkDef((Doc)FaithfulPrettier.highlightVar(raw, def.kind()), (Link)def.target(), (String)this.hover(def.type()));
                return tooltip;
            }
            case 1: {
                HighlightInfo.Ref ref = (HighlightInfo.Ref)highlightInfo2;
                tooltip = Doc.linkRef((Doc)FaithfulPrettier.highlightVar(raw, ref.kind()), (Link)ref.target(), (String)this.hover(ref.type()));
                return tooltip;
            }
            case 2: {
                HighlightInfo.Lit lit = (HighlightInfo.Lit)highlightInfo2;
                tooltip = FaithfulPrettier.highlightLit(raw, lit.kind());
                return tooltip;
            }
            case 3: {
                Style style;
                Doc doc;
                ImmutableSeq<HighlightInfo> problem;
                HighlightInfo.Err err = (HighlightInfo.Err)highlightInfo2;
                try {
                    ImmutableSeq<HighlightInfo> immutableSeq;
                    problem = immutableSeq = err.problem();
                    ImmutableSeq<HighlightInfo> children = immutableSeq = err.children();
                    doc = this.doHighlight(StringSlice.of((String)raw), base, children);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                switch (problem.level()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ERROR: {
                        Style style2 = BasePrettier.ERROR;
                        break;
                    }
                    case WARN: {
                        Style style2 = BasePrettier.WARNING;
                        break;
                    }
                    case GOAL: {
                        Style style2 = BasePrettier.GOAL;
                        break;
                    }
                    case INFO: {
                        Style style2 = style = null;
                    }
                }
                if (style == null) {
                    tooltip = doc;
                    return tooltip;
                }
                tooltip = new Doc.Tooltip(Doc.styled((Style)style, (Doc)doc), () -> Doc.codeBlock((Language)Language.Builtin.Aya, (Doc)problem.brief(this.options()).toDoc()));
                return tooltip;
            }
            case 4: 
        }
        HighlightInfo.UserMeta meta = (HighlightInfo.UserMeta)highlightInfo2;
        tooltip = new Doc.Tooltip(Doc.plain((String)raw), () -> Doc.codeBlock((Language)Language.Builtin.Aya, (Doc)meta.hover().toDoc(this.options())));
        return tooltip;
    }

    @Nullable
    private String hover(@Nullable AyaDocile term) {
        if (term == null) {
            return null;
        }
        return term.toDoc(this.options()).commonRender();
    }

    @NotNull
    private static Doc highlightVar(@NotNull String raw, @NotNull HighlightInfo.DefKind defKind) {
        Style style = switch (defKind) {
            default -> throw new MatchException(null, null);
            case HighlightInfo.DefKind.Data -> BasePrettier.DATA;
            case HighlightInfo.DefKind.Con -> BasePrettier.CON;
            case HighlightInfo.DefKind.Clazz -> BasePrettier.CLAZZ;
            case HighlightInfo.DefKind.Member -> BasePrettier.MEMBER;
            case HighlightInfo.DefKind.Fn -> BasePrettier.FN;
            case HighlightInfo.DefKind.Prim -> BasePrettier.PRIM;
            case HighlightInfo.DefKind.Generalized -> BasePrettier.GENERALIZED;
            case HighlightInfo.DefKind.LocalVar -> BasePrettier.LOCAL_VAR;
            case HighlightInfo.DefKind.Unknown, HighlightInfo.DefKind.Module -> null;
        };
        return style != null ? Doc.styled((Style)style, (String)raw) : Doc.plain((String)raw);
    }

    @NotNull
    private static Doc highlightLit(@NotNull String raw, @NotNull HighlightInfo.LitKind litKind) {
        return switch (litKind) {
            default -> throw new MatchException(null, null);
            case HighlightInfo.LitKind.Int, HighlightInfo.LitKind.Whitespace -> Doc.plain((String)raw);
            case HighlightInfo.LitKind.String -> Doc.plain((String)StringUtil.escapeStringCharacters((String)raw));
            case HighlightInfo.LitKind.Keyword -> Doc.styled((Style)BasePrettier.KEYWORD, (Doc)Doc.symbol((String)raw));
            case HighlightInfo.LitKind.Comment -> Doc.styled((Style)BasePrettier.COMMENT, (String)raw);
            case HighlightInfo.LitKind.SpecialSymbol -> Doc.symbol((String)raw);
            case HighlightInfo.LitKind.Eol -> Doc.cat((SeqLike)Seq.fill((int)raw.length(), (Object)Doc.line()));
        };
    }

    @NotNull
    private static KnifeCut twoKnifeThreeParts(@NotNull StringSlice raw, int base, @NotNull SourcePos twoKnife) {
        int beginPart1 = twoKnife.tokenStartIndex() - base;
        int endPart1 = twoKnife.tokenEndIndex() + 1 - base;
        StringSlice part0 = raw.subSequence(0, beginPart1);
        StringSlice part1 = raw.subSequence(beginPart1, endPart1);
        StringSlice part2 = raw.subSequence(endPart1, raw.length());
        return new KnifeCut(part0, part1, part2, twoKnife.tokenEndIndex() + 1);
    }

    public record KnifeCut(@NotNull StringSlice before, @NotNull StringSlice current, @NotNull StringSlice remaining, int base) {
    }
}

