/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.json.LibraryConfig;
import org.aya.cli.library.json.LibraryDependency;
import org.aya.cli.library.json.LibraryDependencyData;
import org.aya.cli.utils.LiteratePrettierOptions;
import org.aya.util.FileUtil;
import org.aya.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.VisibleForTesting;

public final class LibraryConfigData {
    public String ayaVersion;
    public String name;
    public String group;
    public String version;
    public LibraryLiterateConfigData literate;
    public Map<String, LibraryDependencyData> dependency;

    @VisibleForTesting
    public void checkDeserialization(@NotNull Path libraryRoot) {
        if (this.ayaVersion == null) {
            this.ayaVersion = "0.34.0";
        }
        if (this.name == null) {
            throw new BadConfig("Missing `name` in " + String.valueOf(libraryRoot));
        }
        if (this.group == null) {
            throw new BadConfig("Missing `group` in " + String.valueOf(libraryRoot));
        }
        if (this.version == null) {
            throw new BadConfig("Missing `version in " + String.valueOf(libraryRoot));
        }
        if (this.dependency == null) {
            this.dependency = Map.of();
        }
        if (this.literate == null) {
            this.literate = new LibraryLiterateConfigData();
        }
    }

    @NotNull
    private LibraryConfig asConfig(@NotNull Path libraryRoot) throws JsonParseException {
        Path buildRoot = libraryRoot.resolve("build");
        return this.asConfig(libraryRoot, null, config -> buildRoot);
    }

    @NotNull
    private LibraryConfig asConfig(@NotNull Path libraryRoot, @Nullable LibraryConfig.LibraryLiterateConfig literateConfig, @NotNull Function<String, Path> buildRootGen) {
        this.checkDeserialization(libraryRoot.resolve("aya.json"));
        Path buildRoot = FileUtil.canonicalize((Path)buildRootGen.apply(this.version));
        if (literateConfig == null) {
            literateConfig = this.literate.asConfig(buildRoot.resolve("pretty"));
        }
        return new LibraryConfig(Version.create((String)this.ayaVersion), this.name, this.version, libraryRoot, libraryRoot.resolve("src"), buildRoot, buildRoot.resolve("out"), literateConfig, (ImmutableSeq<LibraryDependency>)ImmutableSeq.from(this.dependency.entrySet()).view().map(e -> ((LibraryDependencyData)e.getValue()).as(libraryRoot, (String)e.getKey())).toImmutableSeq());
    }

    @NotNull
    private static LibraryConfigData of(@NotNull Path root) throws BadConfig, IOException {
        Path ayaJson = root.resolve("aya.json");
        return LibraryConfigData.ofAyaJson(ayaJson);
    }

    @VisibleForTesting
    public static LibraryConfigData ofAyaJson(Path ayaJson) throws IOException {
        LibraryConfigData libraryConfigData;
        block8: {
            BufferedReader jsonReader = Files.newBufferedReader(ayaJson);
            try {
                Gson gson = LiteratePrettierOptions.gsonBuilder(new GsonBuilder()).create();
                libraryConfigData = (LibraryConfigData)gson.fromJson((Reader)jsonReader, LibraryConfigData.class);
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException cause) {
                    throw new BadConfig("Failed to parse " + String.valueOf(ayaJson) + ": " + cause.getMessage());
                }
            }
            jsonReader.close();
        }
        return libraryConfigData;
    }

    @NotNull
    public static LibraryConfig fromLibraryRoot(@NotNull Path libraryRoot) throws IOException, BadConfig {
        Path canonicalPath = FileUtil.canonicalize((Path)libraryRoot);
        return LibraryConfigData.of(canonicalPath).asConfig(canonicalPath);
    }

    @NotNull
    public static LibraryConfig fromDependencyRoot(@NotNull Path dependencyRoot, @Nullable LibraryConfig.LibraryLiterateConfig literateConfig, @NotNull Function<String, Path> buildRoot) throws IOException, BadConfig {
        Path canonicalPath = FileUtil.canonicalize((Path)dependencyRoot);
        return LibraryConfigData.of(canonicalPath).asConfig(canonicalPath, literateConfig, buildRoot);
    }

    public static class BadConfig
    extends RuntimeException {
        public BadConfig(@NotNull String message) {
            super(message);
        }

        public BadConfig(@NotNull String message, @NotNull Throwable cause) {
            super(message, cause);
        }
    }

    public static final class LibraryLiterateConfigData {
        @Nullable
        public LiteratePrettierOptions pretty;
        public @UnknownNullability String linkPrefix;

        public void checkDeserialization() {
            if (this.linkPrefix == null) {
                this.linkPrefix = "/";
            }
        }

        @NotNull
        public LibraryConfig.LibraryLiterateConfig asConfig(@NotNull Path outputPath) {
            this.checkDeserialization();
            return new LibraryConfig.LibraryLiterateConfig(this.pretty, this.linkPrefix, outputPath);
        }
    }
}

