/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.utils;

import java.io.IOException;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import org.aya.cli.literate.AyaMdParser;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.literate.LiterateFaithfulPrettier;
import org.aya.cli.literate.SyntaxHighlight;
import org.aya.literate.Literate;
import org.aya.literate.LiterateConsumer;
import org.aya.normalize.Normalizer;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.salt.Desalt;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.syntax.GenericAyaFile;
import org.aya.syntax.GenericAyaParser;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.core.def.AnyDef;
import org.aya.syntax.core.term.ErrorTerm;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.literate.AyaLiterate;
import org.aya.syntax.literate.CodeOptions;
import org.aya.syntax.ref.AnyDefVar;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.Jdg;
import org.aya.tyck.tycker.TeleTycker;
import org.aya.util.error.PosedUnaryOperator;
import org.aya.util.error.SourceFile;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LiterateData(@NotNull Literate literate, @NotNull ImmutableSeq<AyaLiterate.AyaInlineCode> extractedExprs, @NotNull SourceFile extractedAya) {
    @NotNull
    public static LiterateData create(@NotNull SourceFile mdFile, @NotNull Reporter reporter) {
        AyaMdParser mdParser = new AyaMdParser(mdFile, reporter);
        Literate lit = mdParser.parseLiterate();
        String ayaCode = mdParser.extractAya(lit);
        ImmutableSeq exprs = new LiterateConsumer.InstanceExtractinator(AyaLiterate.AyaInlineCode.class).extract(lit);
        SourceFile code = new SourceFile(mdFile.display(), mdFile.underlying(), ayaCode);
        return new LiterateData(lit, (ImmutableSeq<AyaLiterate.AyaInlineCode>)exprs, code);
    }

    public void parseMe(@NotNull GenericAyaParser parser) {
        this.extractedExprs.forEach(code -> {
            code.expr = parser.expr(code.code, code.sourcePos);
        });
    }

    public void resolve(@NotNull ResolveInfo info) {
        this.extractedExprs.forEach(c -> {
            assert (c.expr != null);
            ExprResolver.LiterateResolved data = ExprResolver.resolveLax((ModuleContext)info.thisModule(), (WithPos)c.expr).descent((PosedUnaryOperator)new Desalt(info));
            c.params = data.params();
            c.expr = data.expr();
        });
    }

    @Nullable
    public static Jdg simpleVar(Expr expr) {
        Expr.Ref ref;
        AnyVar anyVar;
        if (expr instanceof Expr.Ref && (anyVar = (ref = (Expr.Ref)expr).var()) instanceof AnyDefVar) {
            AnyDefVar defVar = (AnyDefVar)anyVar;
            AnyDef anyDef = AnyDef.fromVar((AnyDefVar)defVar);
            return new Jdg.Default((Term)new ErrorTerm(prettierOptions -> BasePrettier.refVar((AnyDef)anyDef), false), anyDef.signature().makePi());
        }
        return null;
    }

    public void tyck(@NotNull ResolveInfo info) {
        this.extractedExprs.forEach(c -> {
            Jdg jdg;
            assert (c.expr != null);
            assert (c.params != null);
            if (c.options.mode() == CodeOptions.NormalizeMode.NULL && (jdg = LiterateData.simpleVar((Expr)c.expr.data())) != null) {
                c.tyckResult = new AyaLiterate.TyckResult(jdg.wellTyped(), jdg.type());
                return;
            }
            ExprTycker tycker = info.newTycker();
            TeleTycker.InlineCode teleTycker = new TeleTycker.InlineCode(tycker);
            Jdg result = teleTycker.checkInlineCode(c.params, c.expr);
            Normalizer normalizer = new Normalizer(tycker.state);
            c.tyckResult = new AyaLiterate.TyckResult(normalizer.normalize(result.wellTyped(), c.options.mode()), normalizer.normalize(result.type(), c.options.mode()));
        });
    }

    @NotNull
    public static Doc toDoc(@NotNull GenericAyaFile ayaFile, @Nullable ModulePath currentFileModule, @NotNull ImmutableSeq<Stmt> program, @NotNull ImmutableSeq<Problem> problems, @NotNull PrettierOptions options) throws IOException {
        ImmutableSeq<HighlightInfo> highlights = SyntaxHighlight.highlight(currentFileModule, (Option<SourceFile>)Option.some((Object)ayaFile.codeFile()), program);
        Literate literate = ayaFile.literate();
        LiterateFaithfulPrettier prettier = new LiterateFaithfulPrettier(problems, highlights, options);
        prettier.accept(literate);
        return literate.toDoc();
    }
}

