/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.render;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kala.control.Try;
import kala.text.StringSlice;
import org.jetbrains.annotations.NotNull;

public class Color {
    public int color;

    public Color() {
    }

    public Color(int color) {
        this.color = color;
    }

    public static final class Adapter
    implements JsonDeserializer<Color>,
    JsonSerializer<Color> {
        public static int parse3(int color) {
            return ((color &= 0xFFF) & 0xF00) << 8 | (color & 0xF0) << 4 | color & 0xF;
        }

        public static int parse4(int color) {
            return ((color &= 0xFFF0) & 0xF000) << 4 | color & 0xF00 | (color & 0xF0) >>> 4;
        }

        public static int parse8(int color) {
            return color >>> 8;
        }

        public static int parse6(int color) {
            return color;
        }

        @NotNull
        public static Try<Integer> parseColor(@NotNull String color) {
            StringSlice colorCode = color.charAt(0) == '#' ? StringSlice.of((String)color, (int)1, (int)color.length()) : (color.startsWith("0x") ? StringSlice.of((String)color, (int)2, (int)color.length()) : StringSlice.of((String)color));
            return Try.of(() -> {
                int value = (int)colorCode.toLong(16);
                return switch (colorCode.length()) {
                    case 3 -> Adapter.parse3(value);
                    case 4 -> Adapter.parse4(value);
                    case 6 -> Adapter.parse6(value);
                    case 8 -> Adapter.parse8(value);
                    default -> throw new NumberFormatException("Invalid color: " + color);
                };
            });
        }

        public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
            assert (src != null);
            return new JsonPrimitive(String.format("#%06X", src.color));
        }

        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            assert (json != null);
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                String colorCode = json.getAsString();
                Try<Integer> parsed = Adapter.parseColor(colorCode);
                if (parsed.isFailure()) {
                    throw new JsonParseException(parsed.getCause());
                }
                return new Color((Integer)parsed.get());
            }
            throw new JsonParseException("expected 'string'");
        }
    }
}

