/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.source.LibrarySource;
import org.aya.syntax.concrete.stmt.Command;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public record ImportResolver(@NotNull ImportLoader loader, @NotNull LibrarySource librarySource) {
    public void resolveStmt(@NotNull SeqLike<Stmt> stmts) throws IOException {
        stmts.forEachChecked(this::resolveStmt);
    }

    public void resolveStmt(@NotNull Stmt stmt) throws IOException {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, Command.Import.class}, (Object)stmt3, n)) {
            case 0: {
                Command.Module mod = (Command.Module)stmt3;
                this.resolveStmt((SeqLike<Stmt>)mod.contents());
                break;
            }
            case 1: {
                Command.Import cmd = (Command.Import)stmt3;
                ModulePath ids = cmd.path();
                LibrarySource success = this.loader.load(ids, cmd.sourcePos());
                MutableList<LibrarySource> imports = this.librarySource.imports();
                if (imports.anyMatch(i -> i.moduleName().equals((Object)success.moduleName()))) {
                    return;
                }
                imports.append((Object)success);
                break;
            }
        }
    }

    @FunctionalInterface
    public static interface ImportLoader {
        @NotNull
        public LibrarySource load(@NotNull ModulePath var1, @NotNull SourcePos var2);
    }
}

