/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.utils;

import java.nio.file.Path;
import org.aya.cli.render.RenderOptions;
import org.jetbrains.annotations.NotNull;

public interface CliEnums {
    @NotNull
    public static PrettyFormat detectFormat(@NotNull Path outputFile) {
        String name = outputFile.getFileName().toString();
        if (name.endsWith(".md")) {
            return PrettyFormat.markdown;
        }
        if (name.endsWith(".tex")) {
            return PrettyFormat.latex;
        }
        if (name.endsWith(".katex")) {
            return PrettyFormat.katex;
        }
        if (name.endsWith(".html")) {
            return PrettyFormat.html;
        }
        return PrettyFormat.plain;
    }

    public static enum PrettyFormat {
        html(RenderOptions.OutputTarget.HTML),
        plain(RenderOptions.OutputTarget.Plain),
        latex(RenderOptions.OutputTarget.LaTeX),
        katex(RenderOptions.OutputTarget.KaTeX),
        markdown(RenderOptions.OutputTarget.AyaMd),
        unix(RenderOptions.OutputTarget.Unix),
        ansi16(RenderOptions.OutputTarget.ANSI16);

        @NotNull
        public final RenderOptions.OutputTarget target;

        private PrettyFormat(RenderOptions.OutputTarget target) {
            this.target = target;
        }
    }

    public static enum PrettyStage {
        raw,
        scoped,
        typed,
        literate;

    }
}

