/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.single;

import java.io.IOException;
import java.nio.file.Path;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.function.BooleanObjBiFunction;
import org.aya.cli.render.RenderOptions;
import org.aya.cli.single.CompilerFlags;
import org.aya.cli.utils.CliEnums;
import org.aya.cli.utils.LiterateData;
import org.aya.generic.AyaDocile;
import org.aya.literate.Literate;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.ResolveInfo;
import org.aya.syntax.AyaFiles;
import org.aya.syntax.GenericAyaFile;
import org.aya.syntax.GenericAyaParser;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.concrete.stmt.decl.Decl;
import org.aya.syntax.core.def.PrimDef;
import org.aya.syntax.core.def.TyckDef;
import org.aya.util.FileUtil;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.CollectingReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public sealed interface SingleAyaFile
extends GenericAyaFile {
    @Nullable
    private static CompilerFlags.PrettyInfo parsePrettyInfo(@NotNull CompilerFlags flags) {
        if (flags.prettyInfo() != null) {
            return flags.prettyInfo();
        }
        return CompilerFlags.prettyInfoFromOutput(flags.outputFile(), new RenderOptions(), false, false, false);
    }

    default public void pretty(@NotNull CompilerFlags compilerFlags, @NotNull ImmutableSeq<? extends AyaDocile> doc, @NotNull CollectingReporter reporter, @NotNull CliEnums.PrettyStage currentStage) throws IOException {
        Object fileName;
        Path prettyDir;
        CompilerFlags.PrettyInfo flags = SingleAyaFile.parsePrettyInfo(compilerFlags);
        if (flags == null || currentStage != flags.prettyStage()) {
            return;
        }
        RenderOptions.OutputTarget out = flags.prettyFormat().target;
        Path outputFile = compilerFlags.outputFile();
        if (outputFile != null) {
            prettyDir = outputFile.toAbsolutePath().getParent();
            fileName = outputFile.getFileName().toString();
        } else {
            prettyDir = flags.prettyDir() != null ? Path.of(flags.prettyDir(), new String[0]) : Path.of(".", new String[0]);
            fileName = AyaFiles.stripAyaSourcePostfix((String)this.originalFile().display()) + out.fileExt;
        }
        RenderOptions renderOptions = flags.renderOptions();
        if (currentStage == CliEnums.PrettyStage.literate) {
            Doc d2 = this.toDoc(doc, (ImmutableSeq<Problem>)reporter.problems().toImmutableSeq(), flags.prettierOptions());
            String text = renderOptions.render(out, d2, flags.backendOpts(true));
            FileUtil.writeString((Path)prettyDir.resolve((String)fileName), (String)text);
        } else {
            this.doWrite(doc, prettyDir, flags.prettierOptions(), (String)fileName, out.fileExt, (BooleanObjBiFunction<Doc, String>)((BooleanObjBiFunction)(hdr, d) -> renderOptions.render(out, (Doc)d, flags.backendOpts(hdr))));
        }
    }

    @VisibleForTesting
    @NotNull
    default public Doc toDoc(@NotNull ImmutableSeq<Stmt> program, @NotNull ImmutableSeq<Problem> problems, @NotNull PrettierOptions options) throws IOException {
        return LiterateData.toDoc(this, null, program, problems, options);
    }

    private void doWrite(ImmutableSeq<? extends AyaDocile> doc, Path prettyDir, @NotNull PrettierOptions options, String fileName, String fileExt, BooleanObjBiFunction<Doc, String> toString) throws IOException {
        MutableList docs = MutableList.create();
        Path eachPrettyDir = prettyDir.resolve(fileName + ".each");
        for (int i = 0; i < doc.size(); ++i) {
            AyaDocile item = (AyaDocile)doc.get(i);
            Doc thisDoc = item.toDoc(options);
            docs.append((Object)thisDoc);
            if (item instanceof PrimDef) continue;
            FileUtil.writeString((Path)eachPrettyDir.resolve(FileUtil.escapeFileName((String)SingleAyaFile.nameOf(i, item)) + fileExt), (String)((String)toString.apply(false, (Object)thisDoc)));
        }
        FileUtil.writeString((Path)prettyDir.resolve(fileName), (String)((String)toString.apply(true, (Object)Doc.vcat((SeqLike)docs))));
    }

    @NotNull
    private static String nameOf(int i, AyaDocile item) {
        String string;
        if (item instanceof TyckDef) {
            TyckDef def = (TyckDef)item;
            string = def.ref().name();
        } else if (item instanceof Decl) {
            Decl decl = (Decl)item;
            string = decl.ref().name();
        } else {
            string = String.valueOf(i);
        }
        return string;
    }

    default public void resolveAdditional(@NotNull ResolveInfo info) {
    }

    @MustBeInvokedByOverriders
    default public void tyckAdditional(@NotNull ResolveInfo info) {
        this.resolveAdditional(info);
    }

    @VisibleForTesting
    @NotNull
    public static MarkdownAyaFile createLiterateFile(@NotNull CodeAyaFile template, @NotNull Reporter reporter) {
        return new MarkdownAyaFile(template.originalFile, LiterateData.create(template.originalFile, reporter));
    }

    public record MarkdownAyaFile(@NotNull SourceFile originalFile, @NotNull LiterateData data) implements SingleAyaFile
    {
        @Override
        public void resolveAdditional(@NotNull ResolveInfo info) {
            SingleAyaFile.super.resolveAdditional(info);
            this.data.resolve(info);
        }

        @Override
        public void tyckAdditional(@NotNull ResolveInfo info) {
            SingleAyaFile.super.tyckAdditional(info);
            this.data.tyck(info);
        }

        @NotNull
        public ImmutableSeq<Stmt> parseMe(@NotNull GenericAyaParser parser) throws IOException {
            this.data.parseMe(parser);
            return SingleAyaFile.super.parseMe(parser);
        }

        @NotNull
        public SourceFile codeFile() {
            return this.data.extractedAya();
        }

        @NotNull
        public Literate literate() {
            return this.data.literate();
        }
    }

    public record CodeAyaFile(@NotNull SourceFile originalFile) implements SingleAyaFile
    {
    }

    public record Factory(@NotNull Reporter reporter) implements GenericAyaFile.Factory
    {
        @NotNull
        public SingleAyaFile createAyaFile(@NotNull SourceFileLocator locator, @NotNull Path path) throws IOException {
            CodeAyaFile codeFile = new CodeAyaFile(SourceFile.from((SourceFileLocator)locator, (Path)path));
            return AyaFiles.isLiterate((Path)path) ? SingleAyaFile.createLiterateFile(codeFile, this.reporter) : codeFile;
        }
    }
}

