/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.render.vscode;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kala.collection.MapLike;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.mutable.MutableMap;
import kala.control.Either;
import org.aya.cli.render.Color;
import org.jetbrains.annotations.Nullable;

public class VscColorTheme {
    @Nullable
    public String name;
    @Nullable
    public String include;
    @Nullable
    public Map<String, Color> colors;
    @Nullable
    public List<TokenColor> tokenColors;
    public static final Seq<String> SCOPE_KEYWORD = Seq.of((Object)"keyword");
    public static final Seq<String> SCOPE_FN_CALL = Seq.of((Object)"function", (Object)"entity.name.function");
    public static final Seq<String> SCOPE_GENERALIZED = Seq.of((Object)"type", (Object)"entity.name.type");
    public static final Seq<String> SCOPE_DATA_CALL = Seq.of((Object)"class", (Object)"entity.name.class", (Object)"entity.name.type.class", (Object)"entity.name.type");
    public static final Seq<String> SCOPE_STRUCT_CALL = Seq.of((Object)"struct", (Object)"entity.name.struct", (Object)"entity.name.type.struct", (Object)"entity.name.type");
    public static final Seq<String> SCOPE_CON_CALL = Seq.of((Object)"member", (Object)"entity.name.function.member", (Object)"entity.name.function");
    public static final Seq<String> SCOPE_FIELD_CALL = Seq.of((Object)"property", (Object)"variable.other.property", (Object)"entity.name.function");

    public ImmutableMap<String, TokenColor.Settings> buildMap() {
        MutableMap builder = MutableMap.create();
        if (this.colors != null) {
            for (Map.Entry entry : this.colors.entrySet()) {
                TokenColor.Settings settings = new TokenColor.Settings();
                settings.foreground = (Color)entry.getValue();
                builder.put((Object)((String)entry.getKey()), (Object)settings);
            }
        }
        if (this.tokenColors != null) {
            for (TokenColor tokenColor : this.tokenColors) {
                Either<String, List<String>> scopes = tokenColor.scope;
                TokenColor.Settings settings = tokenColor.settings;
                if (scopes == null || settings == null) continue;
                ((List)scopes.fold(List::of, Function.identity())).forEach(scope -> {
                    if (scope != null) {
                        builder.put(scope, (Object)settings);
                    }
                });
            }
        }
        return ImmutableMap.from((MapLike)builder);
    }

    public static class TokenColor {
        @Nullable
        public Either<String, List<String>> scope;
        @Nullable
        public Settings settings;

        public static class Settings {
            @Nullable
            public String fontStyle;
            @Nullable
            public Color foreground;
            public boolean bold;
            public boolean italic;
            public boolean underline;
        }
    }
}

