/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import org.aya.generic.AyaDocile;
import org.aya.pretty.doc.Link;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface HighlightInfo
extends Comparable<HighlightInfo> {
    @NotNull
    public SourcePos sourcePos();

    @Override
    default public int compareTo(@NotNull HighlightInfo o) {
        return this.sourcePos().compareTo(o.sourcePos());
    }

    public record Lit(@NotNull SourcePos sourcePos, @NotNull LitKind kind) implements HighlightInfo
    {
    }

    public record Err(@NotNull Problem problem, @NotNull ImmutableSeq<HighlightInfo> children) implements HighlightInfo
    {
        @Override
        @NotNull
        public SourcePos sourcePos() {
            return this.problem.sourcePos();
        }
    }

    public record Def(@NotNull SourcePos sourcePos, @NotNull Link target, @NotNull DefKind kind, @Nullable AyaDocile type) implements HighlightInfo
    {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Def def = (Def)o;
            return Objects.equals(this.sourcePos, def.sourcePos) && Objects.equals(this.target, def.target) && this.kind == def.kind;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.sourcePos, this.target, this.kind});
        }
    }

    public record Ref(@NotNull SourcePos sourcePos, @NotNull Link target, @NotNull DefKind kind, @Nullable AyaDocile type) implements HighlightInfo
    {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ref ref = (Ref)o;
            return Objects.equals(this.sourcePos, ref.sourcePos) && Objects.equals(this.target, ref.target) && this.kind == ref.kind;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.sourcePos, this.target, this.kind});
        }
    }

    public static enum LitKind {
        Int,
        String,
        Keyword,
        Comment,
        SpecialSymbol,
        Eol,
        Whitespace;


        @NotNull
        public HighlightInfo toLit(@NotNull SourcePos sourcePos) {
            return new Lit(sourcePos, this);
        }
    }

    public static enum DefKind {
        Data,
        Con,
        Clazz,
        Member,
        Fn,
        Prim,
        Generalized,
        LocalVar,
        Module,
        Unknown;


        @NotNull
        public HighlightInfo toRef(@NotNull SourcePos sourcePos, @NotNull Link target, @Nullable AyaDocile type) {
            return new Ref(sourcePos, target, this, type);
        }

        @NotNull
        public HighlightInfo toDef(@NotNull SourcePos sourcePos, @NotNull Link target, @Nullable AyaDocile type) {
            return new Def(sourcePos, target, this, type);
        }
    }
}

