/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import org.aya.literate.Literate;
import org.aya.literate.LiterateConsumer;
import org.aya.literate.frontmatter.YamlFrontMatter;
import org.aya.literate.math.InlineMath;
import org.aya.literate.math.MathBlock;
import org.aya.literate.parser.BaseMdParser;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.literate.AyaLiterate;
import org.aya.syntax.literate.CodeAttrProcessor;
import org.aya.syntax.literate.CodeOptions;
import org.aya.util.error.Panic;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Reporter;
import org.commonmark.node.Block;
import org.commonmark.node.Code;
import org.commonmark.node.Node;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.Parser;
import org.commonmark.parser.block.BlockParserFactory;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.jetbrains.annotations.NotNull;

public class AyaMdParser
extends BaseMdParser {
    public AyaMdParser(@NotNull SourceFile file, @NotNull Reporter reporter) {
        super(file, reporter, AyaLiterate.AYA);
    }

    @NotNull
    protected Parser.Builder parserBuilder() {
        return super.parserBuilder().customDelimiterProcessor((DelimiterProcessor)CodeAttrProcessor.INSTANCE).customDelimiterProcessor((DelimiterProcessor)InlineMath.Processor.INSTANCE).customBlockParserFactory((BlockParserFactory)MathBlock.FACTORY).customBlockParserFactory((BlockParserFactory)YamlFrontMatter.FACTORY);
    }

    @NotNull
    public String extractAya(@NotNull Literate literate) {
        return this.etching(new LiterateConsumer.InstanceExtractinator(AyaLiterate.AyaCodeBlock.class).extract(literate).view().map(Function.identity()));
    }

    @NotNull
    protected Literate mapNode(@NotNull Node node) {
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InlineMath.class, MathBlock.class, YamlFrontMatter.class, Code.class}, (Object)node3, n)) {
            case 0 -> {
                InlineMath math = (InlineMath)node3;
                yield new Literate.Math(true, this.mapChildren((Node)math));
            }
            case 1 -> {
                MathBlock math = (MathBlock)node3;
                String formula = this.stripTrailingNewline(math.literal, (Block)math).literal();
                yield new Literate.Math(false, ImmutableSeq.of((Object)new Literate.Raw(Doc.plain((String)formula))));
            }
            case 2 -> {
                YamlFrontMatter yaml = (YamlFrontMatter)node3;
                Doc mark = Doc.plain((String)String.valueOf(yaml.fenceChar).repeat(yaml.fenceLength));
                Doc matter = Doc.vcat((Doc[])new Doc[]{mark, Doc.escaped((String)yaml.literal), mark, Doc.line()});
                Doc doc = yaml.fenceIndent > 0 ? Doc.hang((int)yaml.fenceIndent, (Doc)matter) : matter;
                yield new Literate.Raw(doc);
            }
            case 3 -> {
                Code inlineCode = (Code)node3;
                List spans = inlineCode.getSourceSpans();
                if (spans != null && spans.size() == 1) {
                    SourceSpan sourceSpan = (SourceSpan)spans.getFirst();
                    int lineIndex = this.linesIndex.get(sourceSpan.getLineIndex());
                    int startFrom = lineIndex + sourceSpan.getColumnIndex();
                    SourcePos sourcePos = AyaMdParser.fromSourceSpans((SourceFile)this.file, (int)startFrom, (Seq)Seq.of((Object)sourceSpan));
                    if (!$assertionsDisabled && sourcePos == null) {
                        throw new AssertionError();
                    }
                    yield CodeOptions.analyze((Code)inlineCode, (SourcePos)sourcePos);
                }
                throw new Panic("SourceSpans");
            }
            default -> super.mapNode(node);
        };
    }
}

