/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.json;

import java.nio.file.Path;
import org.aya.cli.library.json.LibraryDependency;
import org.aya.util.error.Panic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDependencyData {
    @Nullable
    public String version;
    @Nullable
    public String github;
    @Nullable
    public String file;

    @NotNull
    public LibraryDependency as(@NotNull Path libraryRoot, @NotNull String depName) {
        if (this.version != null) {
            return new LibraryDependency.DepVersion(depName, this.version);
        }
        if (this.github != null) {
            return new LibraryDependency.DepGithub(depName, this.github);
        }
        if (this.file != null) {
            return new LibraryDependency.DepFile(depName, libraryRoot.resolve(this.file));
        }
        throw new Panic("Unsupported dependency type for " + depName);
    }
}

