/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.incremental;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.utils.CompilerUtil;
import org.aya.compiler.CompiledModule;
import org.aya.compiler.FileSerializer;
import org.aya.compiler.ModuleSerializer;
import org.aya.compiler.NameSerializer;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.module.ModuleLoader;
import org.aya.syntax.core.def.TopLevelDef;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.ref.ModulePath;
import org.aya.syntax.ref.QPath;
import org.aya.util.FileUtil;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiskCompilerAdvisor
implements CompilerAdvisor {
    private final AyaClassLoader cl = new AyaClassLoader();

    @Override
    public void close() throws Exception {
        this.cl.close();
    }

    @Override
    public boolean isSourceModified(@NotNull LibrarySource source) {
        try {
            Path core = source.compiledCorePath();
            if (!Files.exists(core, new LinkOption[0])) {
                return true;
            }
            return Files.getLastModifiedTime(source.underlyingFile(), new LinkOption[0]).compareTo(Files.getLastModifiedTime(core, new LinkOption[0])) > 0;
        }
        catch (IOException ignore) {
            return true;
        }
    }

    @Override
    public void updateLastModified(@NotNull LibrarySource source) {
        try {
            Path core = source.compiledCorePath();
            Files.setLastModifiedTime(core, Files.getLastModifiedTime(source.underlyingFile(), new LinkOption[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void prepareLibraryOutput(@NotNull LibraryOwner owner) throws IOException {
        Files.createDirectories(owner.outDir(), new FileAttribute[0]);
    }

    @Override
    public void clearLibraryOutput(@NotNull LibraryOwner owner) throws IOException {
        FileUtil.deleteRecursively((Path)owner.outDir());
    }

    @Override
    public void clearModuleOutput(@NotNull LibrarySource source) throws IOException {
        Files.deleteIfExists(source.compiledCorePath());
    }

    @Override
    @Nullable
    public ResolveInfo doLoadCompiledCore(@NotNull Reporter reporter, @NotNull LibraryOwner owner, @NotNull ModulePath mod, @Nullable Path sourcePath, @Nullable Path corePath, @NotNull ModuleLoader recurseLoader) throws IOException, ClassNotFoundException {
        if (corePath == null || sourcePath == null) {
            return null;
        }
        if (!Files.exists(corePath, new LinkOption[0])) {
            return null;
        }
        PhysicalModuleContext context = new EmptyContext(reporter, sourcePath).derive(mod);
        try (ObjectInputStream inputStream = FileUtil.ois((Path)corePath);){
            CompiledModule compiledAya = (CompiledModule)inputStream.readObject();
            int parentCount = mod.size();
            Path baseDir = corePath;
            for (int i = 0; i < parentCount; ++i) {
                baseDir = baseDir.getParent();
            }
            baseDir = DiskCompilerAdvisor.computeBaseDir(baseDir);
            this.cl.addURL(baseDir);
            this.cl.loadClass(NameSerializer.getModuleReference((QPath)QPath.fileLevel((ModulePath)mod)));
            ResolveInfo resolveInfo = compiledAya.toResolveInfo(recurseLoader, context, (ClassLoader)this.cl);
            return resolveInfo;
        }
    }

    @Override
    public void doSaveCompiledCore(@NotNull LibrarySource file, @NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<TyckDef> defs) throws IOException {
        String javaCode = new FileSerializer(resolveInfo.shapeFactory()).serialize(new ModuleSerializer.ModuleResult(QPath.fileLevel((ModulePath)file.moduleName()), defs.filterIsInstance(TopLevelDef.class), ImmutableSeq.empty())).result();
        Path baseDir = DiskCompilerAdvisor.computeBaseDir(file.owner().outDir()).toAbsolutePath();
        String relativePath = NameSerializer.getReference((QPath)QPath.fileLevel((ModulePath)file.moduleName()), null, (NameSerializer.NameType)NameSerializer.NameType.ClassPath) + ".java";
        Path javaSrcPath = baseDir.resolve(relativePath);
        FileUtil.writeString((Path)javaSrcPath, (String)javaCode);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjects(javaSrcPath);
        SeqView classpath = this.cl.urls.view().appended((Object)baseDir).map(Path::toString).appended((Object)System.getProperty("java.class.path"));
        List<String> options = List.of("-classpath", classpath.joinToString((CharSequence)File.pathSeparator), "--enable-preview", "--release", "21");
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, options, null, compilationUnits);
        task.call();
        Path coreFile = file.compiledCorePath();
        CompilerUtil.saveCompiledCore(coreFile, defs, resolveInfo);
    }

    @NotNull
    private static Path computeBaseDir(@NotNull Path outDir) {
        return outDir.resolve("compiled");
    }

    private static class AyaClassLoader
    extends URLClassLoader {
        public MutableList<Path> urls = MutableList.create();

        public AyaClassLoader() {
            super(new URL[0], DiskCompilerAdvisor.class.getClassLoader());
        }

        public void addURL(Path url) throws MalformedURLException {
            this.addURL(url.toUri().toURL());
            this.urls.append((Object)url);
        }
    }
}

