/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.literate.FaithfulPrettier;
import org.aya.cli.literate.HighlightInfo;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Link;
import org.aya.producer.flcl.FlclToken;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public record FlclFaithfulPrettier(@NotNull PrettierOptions options) implements FaithfulPrettier
{
    @NotNull
    public static final Link EMPTY_LINK = Link.page((String)"");

    @NotNull
    public static HighlightInfo toInfo(FlclToken flclToken) {
        SourcePos range = flclToken.range();
        return switch (flclToken.type()) {
            default -> throw new MatchException(null, null);
            case FlclToken.Type.Keyword -> new HighlightInfo.Lit(range, HighlightInfo.LitKind.Keyword);
            case FlclToken.Type.Number -> new HighlightInfo.Lit(range, HighlightInfo.LitKind.Int);
            case FlclToken.Type.Comment -> new HighlightInfo.Lit(range, HighlightInfo.LitKind.Comment);
            case FlclToken.Type.Symbol -> new HighlightInfo.Lit(range, HighlightInfo.LitKind.SpecialSymbol);
            case FlclToken.Type.WhiteSpace -> new HighlightInfo.Lit(range, HighlightInfo.LitKind.Whitespace);
            case FlclToken.Type.Eol -> new HighlightInfo.Lit(range, HighlightInfo.LitKind.Eol);
            case FlclToken.Type.Fn -> FlclFaithfulPrettier.createRef(range, HighlightInfo.DefKind.Fn);
            case FlclToken.Type.Data -> FlclFaithfulPrettier.createRef(range, HighlightInfo.DefKind.Data);
            case FlclToken.Type.Constructor -> FlclFaithfulPrettier.createRef(range, HighlightInfo.DefKind.Con);
            case FlclToken.Type.Primitive -> FlclFaithfulPrettier.createRef(range, HighlightInfo.DefKind.Prim);
            case FlclToken.Type.Local -> FlclFaithfulPrettier.createRef(range, HighlightInfo.DefKind.LocalVar);
        };
    }

    @NotNull
    private static HighlightInfo.Ref createRef(@NotNull SourcePos range, @NotNull HighlightInfo.DefKind kind) {
        return new HighlightInfo.Ref(range, EMPTY_LINK, kind, null);
    }

    @NotNull
    public Doc highlight(@NotNull FlclToken.File file) {
        ImmutableSeq highlights = file.tokens().view().map(FlclFaithfulPrettier::toInfo).sorted().toImmutableSeq();
        FaithfulPrettier.checkHighlights((ImmutableSeq<HighlightInfo>)highlights);
        return this.doHighlight(file.sourceCode(), file.startIndex(), (ImmutableSeq<HighlightInfo>)highlights);
    }
}

