/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import kala.value.LazyValue;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.parse.AyaProducer;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.GeneralizedVar;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.ClassDecl;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.concrete.visitor.StmtFolder;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.MemberDef;
import org.aya.core.def.PrimDef;
import org.aya.core.term.Term;
import org.aya.generic.AyaDocile;
import org.aya.parser.AyaParserDefinitionBase;
import org.aya.parser.ParserDefBase;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Link;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.GenerateKind;
import org.aya.ref.LocalVar;
import org.aya.resolve.context.ModuleName;
import org.aya.util.error.InternalException;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SyntaxHighlight(@Nullable ImmutableSeq<String> currentFileModule) implements StmtFolder<MutableList<HighlightInfo>>
{
    @NotNull
    public static final TokenSet SPECIAL_SYMBOL = TokenSet.orSet((TokenSet[])new TokenSet[]{AyaParserDefinitionBase.UNICODES, AyaParserDefinitionBase.MARKERS, AyaParserDefinitionBase.DELIMITERS});

    @NotNull
    public static ImmutableSeq<HighlightInfo> highlight(@Nullable ImmutableSeq<String> currentFileModule, @NotNull Option<SourceFile> sourceFile, @NotNull ImmutableSeq<Stmt> program) {
        SyntaxHighlight prettier = new SyntaxHighlight(currentFileModule);
        ImmutableSeq semantics = program.flatMap((Function)((Object)prettier));
        if (sourceFile.isDefined()) {
            SourceFile file = (SourceFile)sourceFile.get();
            FlexLexer lexer = AyaParserDefinitionBase.createLexer((boolean)false);
            lexer.reset((CharSequence)file.sourceCode(), 0, file.sourceCode().length(), 0);
            ImmutableSeq addition = lexer.allTheWayDown().view().mapNotNull(token -> {
                IElementType tokenType = token.type();
                if (AyaParserDefinitionBase.KEYWORDS.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.Keyword);
                }
                if (ParserDefBase.COMMENTS.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.Comment);
                }
                if (SPECIAL_SYMBOL.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.SpecialSymbol);
                }
                if (tokenType == TokenType.WHITE_SPACE) {
                    String text = token.range().substring(file.sourceCode());
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), text.contains("\n") ? HighlightInfo.LitKind.Eol : HighlightInfo.LitKind.Whitespace);
                }
                return null;
            }).toImmutableSeq();
            semantics = semantics.concat((SeqLike)addition);
        }
        return semantics;
    }

    @NotNull
    private MutableList<HighlightInfo> add(@NotNull MutableList<HighlightInfo> x, @NotNull HighlightInfo info) {
        x.append((Object)info);
        return x;
    }

    @NotNull
    public MutableList<HighlightInfo> init() {
        return MutableList.create();
    }

    @NotNull
    public MutableList<HighlightInfo> foldVarRef(@NotNull MutableList<HighlightInfo> acc, @NotNull AnyVar var, @NotNull SourcePos pos, @NotNull LazyValue<@Nullable Term> type) {
        return this.add(acc, this.linkRef(pos, var, (AyaDocile)type.get()));
    }

    @NotNull
    public MutableList<HighlightInfo> foldVarDecl(@NotNull MutableList<HighlightInfo> acc, @NotNull AnyVar var, @NotNull SourcePos pos, @NotNull LazyValue<@Nullable Term> type) {
        LocalVar v;
        if (var instanceof LocalVar && (v = (LocalVar)var).isGenerated()) {
            return acc;
        }
        return this.add(acc, this.linkDef(pos, var, (AyaDocile)type.get()));
    }

    @NotNull
    public MutableList<HighlightInfo> fold(@NotNull MutableList<HighlightInfo> acc, @NotNull Expr expr) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.LitInt.class, Expr.LitString.class}, (Object)expr3, n)) {
            case 0 -> {
                Expr.LitInt lit = (Expr.LitInt)expr3;
                yield this.add(acc, HighlightInfo.LitKind.Int.toLit(lit.sourcePos()));
            }
            case 1 -> {
                Expr.LitString lit = (Expr.LitString)expr3;
                yield this.add(acc, HighlightInfo.LitKind.String.toLit(lit.sourcePos()));
            }
            default -> (MutableList<HighlightInfo>)super.fold(acc, expr);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public MutableList<HighlightInfo> fold(@NotNull MutableList<HighlightInfo> acc, @NotNull Pattern pat) {
        MutableList<HighlightInfo> mutableList;
        Pattern pattern = pat;
        Objects.requireNonNull(pattern);
        Pattern pattern2 = pattern;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Number.class}, (Object)pattern2, n)) {
            case 0: {
                Pattern.Number number = (Pattern.Number)pattern2;
                try {
                    SourcePos sourcePos;
                    SourcePos pos = sourcePos = number.sourcePos();
                    int n2 = number.number();
                    mutableList = this.add(acc, HighlightInfo.LitKind.Int.toLit(pos));
                    return mutableList;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
            }
        }
        mutableList = (MutableList<HighlightInfo>)super.fold(acc, pat);
        return mutableList;
    }

    @NotNull
    public MutableList<HighlightInfo> foldModuleRef(@NotNull MutableList<HighlightInfo> acc, @NotNull SourcePos pos, @NotNull ModuleName path) {
        Link link = this.currentFileModule != null && this.currentFileModule.sameElements((Iterable)path.ids()) ? Link.loc((String)path.toString()) : Link.cross((ImmutableSeq)path.ids(), null);
        return this.add(acc, HighlightInfo.DefKind.Module.toRef(pos, link, null));
    }

    @NotNull
    public MutableList<HighlightInfo> foldModuleDecl(@NotNull MutableList<HighlightInfo> acc, @NotNull SourcePos pos, @NotNull ModuleName path) {
        return this.add(acc, HighlightInfo.DefKind.Module.toDef(pos, (Link)Link.loc((String)path.toString()), null));
    }

    @NotNull
    private HighlightInfo linkDef(@NotNull SourcePos sourcePos, @NotNull AnyVar var, @Nullable AyaDocile type) {
        return SyntaxHighlight.kindOf(var).toDef(sourcePos, BasePrettier.linkIdOf(this.currentFileModule, (AnyVar)var), type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private HighlightInfo linkRef(@NotNull SourcePos sourcePos, @NotNull AnyVar var, @Nullable AyaDocile type) {
        String string;
        if (!(var instanceof LocalVar)) return SyntaxHighlight.kindOf(var).toRef(sourcePos, BasePrettier.linkIdOf(this.currentFileModule, (AnyVar)var), type);
        LocalVar localVar = (LocalVar)var;
        try {
            string = localVar.name();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
        string = localVar.definition();
        string = localVar.generateKind();
        if (!(string instanceof GenerateKind.Generalized)) return SyntaxHighlight.kindOf(var).toRef(sourcePos, BasePrettier.linkIdOf(this.currentFileModule, (AnyVar)var), type);
        GenerateKind.Generalized generalized = (GenerateKind.Generalized)string;
        String origin = string = generalized.origin();
        return this.linkRef(sourcePos, (AnyVar)origin, type);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static HighlightInfo.DefKind kindOf(@NotNull AnyVar var) {
        HighlightInfo.DefKind defKind;
        AnyVar anyVar = var;
        Objects.requireNonNull(anyVar);
        AnyVar anyVar2 = anyVar;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, LocalVar.class, LocalVar.class}, (Object)anyVar2, n)) {
                case 0: {
                    defKind = HighlightInfo.DefKind.Generalized;
                    return defKind;
                }
                case 1: {
                    DefVar defVar = (DefVar)anyVar2;
                    if (defVar.concrete instanceof TeleDecl.FnDecl || defVar.core instanceof FnDef) {
                        defKind = HighlightInfo.DefKind.Fn;
                        return defKind;
                    }
                    if (defVar.concrete instanceof TeleDecl.ClassMember || defVar.core instanceof MemberDef) {
                        defKind = HighlightInfo.DefKind.Member;
                        return defKind;
                    }
                    if (defVar.concrete instanceof TeleDecl.DataDecl || defVar.core instanceof DataDef) {
                        defKind = HighlightInfo.DefKind.Data;
                        return defKind;
                    }
                    if (defVar.concrete instanceof TeleDecl.DataCtor || defVar.core instanceof CtorDef) {
                        defKind = HighlightInfo.DefKind.Con;
                        return defKind;
                    }
                    if (defVar.concrete instanceof TeleDecl.PrimDecl || defVar.core instanceof PrimDef) {
                        defKind = HighlightInfo.DefKind.Prim;
                        return defKind;
                    }
                    if (!(defVar.concrete instanceof ClassDecl)) {
                        if (!(defVar.core instanceof ClassDef)) throw new InternalException("unknown def type: " + String.valueOf(defVar));
                    }
                    defKind = HighlightInfo.DefKind.Clazz;
                    return defKind;
                }
                case 2: {
                    String string;
                    LocalVar localVar = (LocalVar)anyVar2;
                    try {
                        string = localVar.name();
                        string = localVar.definition();
                        string = localVar.generateKind();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable.toString(), throwable);
                    }
                    if (string instanceof GenerateKind.Generalized) {
                        GenerateKind.Generalized generalized = (GenerateKind.Generalized)string;
                        {
                            string = generalized.origin();
                        }
                    } else {
                        n = 3;
                        continue block9;
                    }
                    defKind = HighlightInfo.DefKind.Generalized;
                    return defKind;
                }
                case 3: {
                    defKind = HighlightInfo.DefKind.LocalVar;
                    return defKind;
                }
            }
            break;
        }
        defKind = HighlightInfo.DefKind.Unknown;
        return defKind;
    }
}

