/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.incremental;

import java.io.IOException;
import java.nio.file.Path;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.incremental.DiskCompilerAdvisor;
import org.aya.cli.library.incremental.InMemoryCompilerAdvisor;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.parse.AyaParserImpl;
import org.aya.concrete.GenericAyaParser;
import org.aya.core.def.GenericDef;
import org.aya.core.serde.SerTerm;
import org.aya.core.serde.Serializer;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.module.CachedModuleLoader;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.error.InternalException;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CompilerAdvisor {
    @NotNull
    public static CompilerAdvisor onDisk() {
        return new DiskCompilerAdvisor();
    }

    @NotNull
    public static CompilerAdvisor inMemory() {
        return new InMemoryCompilerAdvisor();
    }

    public boolean isSourceModified(@NotNull LibrarySource var1);

    public void updateLastModified(@NotNull LibrarySource var1);

    public void prepareLibraryOutput(@NotNull LibraryOwner var1) throws IOException;

    public void clearLibraryOutput(@NotNull LibraryOwner var1) throws IOException;

    public void clearModuleOutput(@NotNull LibrarySource var1) throws IOException;

    @NotNull
    default public GenericAyaParser createParser(@NotNull Reporter reporter) {
        return new AyaParserImpl(reporter);
    }

    default public void notifyIncrementalJob(@NotNull ImmutableSeq<LibrarySource> modified, @NotNull ImmutableSeq<ImmutableSeq<LibrarySource>> affected) {
    }

    @Nullable
    public ResolveInfo doLoadCompiledCore(@NotNull SerTerm.DeState var1, @NotNull Reporter var2, @NotNull ImmutableSeq<String> var3, @Nullable Path var4, @Nullable Path var5, @NotNull ModuleLoader var6) throws IOException, ClassNotFoundException;

    public void doSaveCompiledCore(@NotNull Serializer.State var1, @NotNull LibrarySource var2, @NotNull ResolveInfo var3, @NotNull ImmutableSeq<GenericDef> var4) throws IOException;

    @ApiStatus.NonExtendable
    @Nullable
    default public ResolveInfo loadCompiledCore(@NotNull SerTerm.DeState deState, @NotNull Reporter reporter, @NotNull ImmutableSeq<String> mod, @Nullable Path sourcePath, @Nullable Path corePath, @NotNull ModuleLoader recurseLoader) {
        if (!1.$assertionsDisabled && !(recurseLoader instanceof CachedModuleLoader)) {
            throw new AssertionError();
        }
        try {
            return this.doLoadCompiledCore(deState, reporter, mod, sourcePath, corePath, recurseLoader);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InternalException("Compiled aya found but cannot be loaded", (Throwable)e);
        }
    }

    @ApiStatus.NonExtendable
    default public void saveCompiledCore(@NotNull Serializer.State serState, @NotNull LibrarySource file, @NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<GenericDef> defs) {
        try {
            this.doSaveCompiledCore(serState, file, resolveInfo, defs);
            this.updateLastModified(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

