/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.parse;

import com.intellij.lang.Language;
import com.intellij.psi.TokenType;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.aya.cli.parse.AyaProducer;
import org.aya.concrete.error.ParseError;
import org.aya.intellij.GenericNode;
import org.aya.util.error.SourceFile;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;

public interface ParserUtil {
    @NotNull
    public static final TokenSet ERROR = TokenSet.create((IElementType[])new IElementType[]{TokenType.ERROR_ELEMENT, TokenType.BAD_CHARACTER});

    @NotNull
    public static GenericNode<?> reportErrorElements(@NotNull GenericNode<?> node, @NotNull SourceFile file, @NotNull Reporter reporter) {
        node.childrenView().filter(i -> ERROR.contains(i.elementType())).forEach(e -> reporter.report((Problem)new ParseError(AyaProducer.sourcePosOf(e, file), "Cannot parse")));
        return node;
    }

    @NotNull
    public static IFileElementType forLanguage(@NotNull Language language) {
        return new IFileElementType(language){

            public void parse(@NotNull FleetPsiBuilder<?> builder) {
            }
        };
    }
}

