/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.utils;

import java.io.IOException;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import org.aya.cli.literate.AyaMdParser;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.literate.LiterateFaithfulPrettier;
import org.aya.cli.literate.SyntaxHighlight;
import org.aya.concrete.GenericAyaFile;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.desugar.Desugarer;
import org.aya.concrete.remark.AyaLiterate;
import org.aya.concrete.stmt.Stmt;
import org.aya.literate.Literate;
import org.aya.literate.LiterateConsumer;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.ResolveInfo;
import org.aya.tyck.ExprTycker;
import org.aya.util.error.SourceFile;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LiterateData(@NotNull Literate literate, @NotNull ImmutableSeq<AyaLiterate.AyaInlineCode> extractedExprs, @NotNull SourceFile extractedAya) {
    @NotNull
    public static LiterateData create(@NotNull SourceFile mdFile, @NotNull Reporter reporter) {
        AyaMdParser mdParser = new AyaMdParser(mdFile, reporter);
        Literate lit = mdParser.parseLiterate();
        String ayaCode = mdParser.extractAya(lit);
        ImmutableSeq exprs = new LiterateConsumer.InstanceExtractinator(AyaLiterate.AyaInlineCode.class).extract(lit);
        SourceFile code = new SourceFile(mdFile.display(), mdFile.underlying(), ayaCode);
        return new LiterateData(lit, (ImmutableSeq<AyaLiterate.AyaInlineCode>)exprs, code);
    }

    public void parseMe(@NotNull GenericAyaParser parser) {
        this.extractedExprs.forEach(code -> {
            code.expr = parser.expr(code.code, code.sourcePos);
        });
    }

    public void resolve(@NotNull ResolveInfo info) {
        this.extractedExprs.forEach(c -> {
            assert (c.expr != null);
            c.expr = new Desugarer(info).apply(c.expr.resolveLax(info.thisModule()));
        });
    }

    public void tyck(@NotNull ResolveInfo info) {
        ExprTycker tycker = info.newTycker(info.thisModule().reporter(), null);
        this.extractedExprs.forEach(c -> {
            assert (c.expr != null);
            c.tyckResult = tycker.zonk(tycker.synthesize(c.expr)).normalize(c.options.mode(), tycker.state);
        });
    }

    @NotNull
    public static Doc toDoc(@NotNull GenericAyaFile ayaFile, @Nullable ImmutableSeq<String> currentFileModule, @NotNull ImmutableSeq<Stmt> program, @NotNull ImmutableSeq<Problem> problems, @NotNull PrettierOptions options) throws IOException {
        ImmutableSeq<HighlightInfo> highlights = SyntaxHighlight.highlight(currentFileModule, (Option<SourceFile>)Option.some((Object)ayaFile.codeFile()), program);
        Literate literate = ayaFile.literate();
        LiterateFaithfulPrettier prettier = new LiterateFaithfulPrettier(problems, highlights, options);
        prettier.accept(literate);
        return literate.toDoc();
    }
}

