/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import kala.value.LazyValue;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.parse.AyaProducer;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.GeneralizedVar;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.ClassDecl;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.concrete.visitor.StmtFolder;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.MemberDef;
import org.aya.core.def.PrimDef;
import org.aya.core.term.Term;
import org.aya.generic.AyaDocile;
import org.aya.parser.AyaParserDefinitionBase;
import org.aya.parser.ParserDefBase;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Link;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.GenerateKind;
import org.aya.ref.LocalVar;
import org.aya.resolve.context.ModuleName;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SyntaxHighlight(@Nullable ImmutableSeq<String> currentFileModule) implements StmtFolder<MutableList<HighlightInfo>>
{
    @NotNull
    public static final TokenSet SPECIAL_SYMBOL = TokenSet.orSet((TokenSet[])new TokenSet[]{AyaParserDefinitionBase.UNICODES, AyaParserDefinitionBase.MARKERS, AyaParserDefinitionBase.DELIMITERS});

    @NotNull
    public static ImmutableSeq<HighlightInfo> highlight(@Nullable ImmutableSeq<String> currentFileModule, @NotNull Option<SourceFile> sourceFile, @NotNull ImmutableSeq<Stmt> program) {
        SyntaxHighlight prettier = new SyntaxHighlight(currentFileModule);
        ImmutableSeq semantics = program.flatMap((Function)((Object)prettier));
        if (sourceFile.isDefined()) {
            SourceFile file = (SourceFile)sourceFile.get();
            FlexLexer lexer = AyaParserDefinitionBase.createLexer((boolean)false);
            lexer.reset((CharSequence)file.sourceCode(), 0, file.sourceCode().length(), 0);
            ImmutableSeq addition = lexer.allTheWayDown().view().mapNotNull(token -> {
                IElementType tokenType = token.type();
                if (AyaParserDefinitionBase.KEYWORDS.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.Keyword);
                }
                if (ParserDefBase.COMMENTS.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.Comment);
                }
                if (SPECIAL_SYMBOL.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.SpecialSymbol);
                }
                if (tokenType == TokenType.WHITE_SPACE) {
                    String text = token.range().substring(file.sourceCode());
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), text.contains("\n") ? HighlightInfo.LitKind.Eol : HighlightInfo.LitKind.Whitespace);
                }
                return null;
            }).toImmutableSeq();
            semantics = semantics.concat((SeqLike)addition);
        }
        return semantics;
    }

    @NotNull
    private MutableList<HighlightInfo> add(@NotNull MutableList<HighlightInfo> x, @NotNull HighlightInfo info) {
        x.append((Object)info);
        return x;
    }

    @NotNull
    public MutableList<HighlightInfo> init() {
        return MutableList.create();
    }

    @NotNull
    public MutableList<HighlightInfo> foldVarRef(@NotNull MutableList<HighlightInfo> acc, @NotNull AnyVar var, @NotNull SourcePos pos, @NotNull LazyValue<@Nullable Term> type) {
        return this.add(acc, this.linkRef(pos, var, (AyaDocile)type.get()));
    }

    @NotNull
    public MutableList<HighlightInfo> foldVarDecl(@NotNull MutableList<HighlightInfo> acc, @NotNull AnyVar var, @NotNull SourcePos pos, @NotNull LazyValue<@Nullable Term> type) {
        LocalVar v;
        if (var instanceof LocalVar && (v = (LocalVar)var).isGenerated()) {
            return acc;
        }
        return this.add(acc, this.linkDef(pos, var, (AyaDocile)type.get()));
    }

    @NotNull
    public MutableList<HighlightInfo> fold(@NotNull MutableList<HighlightInfo> acc, @NotNull Expr expr) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.LitInt.class, Expr.LitString.class}, (Object)expr3, n)) {
            case 0 -> {
                Expr.LitInt lit = (Expr.LitInt)expr3;
                yield this.add(acc, HighlightInfo.LitKind.Int.toLit(lit.sourcePos()));
            }
            case 1 -> {
                Expr.LitString lit = (Expr.LitString)expr3;
                yield this.add(acc, HighlightInfo.LitKind.String.toLit(lit.sourcePos()));
            }
            default -> (MutableList<HighlightInfo>)super.fold(acc, expr);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public MutableList<HighlightInfo> fold(@NotNull MutableList<HighlightInfo> acc, @NotNull Pattern pat) {
        MutableList<HighlightInfo> mutableList;
        Pattern pattern = pat;
        Objects.requireNonNull(pattern);
        Pattern pattern2 = pattern;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Number.class}, (Object)pattern2, n)) {
            case 0: {
                Pattern.Number number = (Pattern.Number)pattern2;
                try {
                    int n2;
                    SourcePos sourcePos;
                    SourcePos pos = sourcePos = number.sourcePos();
                    int $ = n2 = number.number();
                    mutableList = this.add(acc, HighlightInfo.LitKind.Int.toLit(pos));
                    return mutableList;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
            }
        }
        mutableList = (MutableList<HighlightInfo>)super.fold(acc, pat);
        return mutableList;
    }

    @NotNull
    public MutableList<HighlightInfo> foldModuleRef(@NotNull MutableList<HighlightInfo> acc, @NotNull SourcePos pos, @NotNull ModuleName path) {
        Link link = this.currentFileModule != null && this.currentFileModule.sameElements((Iterable)path.ids()) ? Link.loc((String)path.toString()) : Link.cross((ImmutableSeq)path.ids(), null);
        return this.add(acc, HighlightInfo.DefKind.Module.toRef(pos, link, null));
    }

    @NotNull
    public MutableList<HighlightInfo> foldModuleDecl(@NotNull MutableList<HighlightInfo> acc, @NotNull SourcePos pos, @NotNull ModuleName path) {
        return this.add(acc, HighlightInfo.DefKind.Module.toDef(pos, (Link)Link.loc((String)path.toString()), null));
    }

    @NotNull
    private HighlightInfo linkDef(@NotNull SourcePos sourcePos, @NotNull AnyVar var, @Nullable AyaDocile type) {
        return SyntaxHighlight.kindOf(var).toDef(sourcePos, BasePrettier.linkIdOf(this.currentFileModule, (AnyVar)var), type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private HighlightInfo linkRef(@NotNull SourcePos sourcePos, @NotNull AnyVar var, @Nullable AyaDocile type) {
        String string;
        if (!(var instanceof LocalVar)) return SyntaxHighlight.kindOf(var).toRef(sourcePos, BasePrettier.linkIdOf(this.currentFileModule, (AnyVar)var), type);
        LocalVar localVar = (LocalVar)var;
        try {
            String $ = string = localVar.name();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
        String $$ = string = localVar.definition();
        string = localVar.generateKind();
        if (!(string instanceof GenerateKind.Generalized)) return SyntaxHighlight.kindOf(var).toRef(sourcePos, BasePrettier.linkIdOf(this.currentFileModule, (AnyVar)var), type);
        GenerateKind.Generalized generalized = (GenerateKind.Generalized)string;
        String origin = string = generalized.origin();
        return this.linkRef(sourcePos, (AnyVar)origin, type);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static HighlightInfo.DefKind kindOf(@NotNull AnyVar var) {
        HighlightInfo.DefKind defKind;
        AnyVar anyVar = var;
        Objects.requireNonNull(anyVar);
        AnyVar anyVar2 = anyVar;
        int n = 0;
        block46: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, LocalVar.class, LocalVar.class}, (Object)anyVar2, n)) {
                case 0: {
                    GeneralizedVar ignored = (GeneralizedVar)anyVar2;
                    defKind = HighlightInfo.DefKind.Generalized;
                    break block46;
                }
                case 1: {
                    Decl decl;
                    DefVar defVar = (DefVar)anyVar2;
                    record P(Decl decl, GenericDef def) {
                    }
                    P p = new P(defVar.concrete, defVar.core);
                    Objects.requireNonNull(p);
                    Object object = p;
                    int n2 = 0;
                    block47: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{P.class, P.class, P.class, P.class, P.class, P.class}, (Object)object, n2)) {
                            default: {
                                throw new RuntimeException(null, null);
                            }
                            case 0: {
                                Object object2 = object;
                                decl = ((P)object2).decl();
                                int n3 = 0;
                                block48: while (true) {
                                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TeleDecl.FnDecl.class, ClassDecl.class, TeleDecl.ClassMember.class, TeleDecl.DataDecl.class, TeleDecl.DataCtor.class, TeleDecl.PrimDecl.class, Decl.class}, (Object)decl, n3)) {
                                        case 0: {
                                            GenericDef genericDef;
                                            TeleDecl.FnDecl $ = (TeleDecl.FnDecl)decl;
                                            GenericDef $$ = genericDef = ((P)object2).def();
                                            defKind = HighlightInfo.DefKind.Fn;
                                            break block46;
                                        }
                                        case 1: {
                                            GenericDef genericDef;
                                            ClassDecl $ = (ClassDecl)decl;
                                            GenericDef $$ = genericDef = ((P)object2).def();
                                            defKind = HighlightInfo.DefKind.Clazz;
                                            break block46;
                                        }
                                        case 2: {
                                            GenericDef genericDef;
                                            TeleDecl.ClassMember $ = (TeleDecl.ClassMember)decl;
                                            GenericDef $$ = genericDef = ((P)object2).def();
                                            defKind = HighlightInfo.DefKind.Member;
                                            break block46;
                                        }
                                        case 3: {
                                            GenericDef genericDef;
                                            TeleDecl.DataDecl $ = (TeleDecl.DataDecl)decl;
                                            GenericDef $$ = genericDef = ((P)object2).def();
                                            defKind = HighlightInfo.DefKind.Data;
                                            break block46;
                                        }
                                        case 4: {
                                            GenericDef genericDef;
                                            TeleDecl.DataCtor $ = (TeleDecl.DataCtor)decl;
                                            GenericDef $$ = genericDef = ((P)object2).def();
                                            defKind = HighlightInfo.DefKind.Con;
                                            break block46;
                                        }
                                        case 5: {
                                            GenericDef genericDef;
                                            TeleDecl.PrimDecl $ = (TeleDecl.PrimDecl)decl;
                                            GenericDef $$ = genericDef = ((P)object2).def();
                                            defKind = HighlightInfo.DefKind.Prim;
                                            break block46;
                                        }
                                        case -1: 
                                        case 6: {
                                            GenericDef genericDef;
                                            Decl $ = decl;
                                            if ($ != null) {
                                                genericDef = ((P)object2).def();
                                                if (genericDef instanceof FnDef) {
                                                    FnDef $$ = (FnDef)genericDef;
                                                } else {
                                                    n3 = 7;
                                                    continue block48;
                                                }
                                            }
                                            defKind = HighlightInfo.DefKind.Fn;
                                            break block46;
                                        }
                                    }
                                    break;
                                }
                                n2 = 1;
                                continue block47;
                            }
                            case 1: {
                                Object object3 = object;
                                Decl $ = decl = ((P)object3).decl();
                                decl = ((P)object3).def();
                                if (!(decl instanceof ClassDef)) {
                                    n2 = 2;
                                    continue block47;
                                }
                                ClassDef $$ = (ClassDef)decl;
                                defKind = HighlightInfo.DefKind.Clazz;
                                break block46;
                            }
                            case 2: {
                                Object object4 = object;
                                Decl $ = decl = ((P)object4).decl();
                                decl = ((P)object4).def();
                                if (!(decl instanceof MemberDef)) {
                                    n2 = 3;
                                    continue block47;
                                }
                                MemberDef $$ = (MemberDef)decl;
                                defKind = HighlightInfo.DefKind.Member;
                                break block46;
                            }
                            case 3: {
                                Object object5 = object;
                                Decl $ = decl = ((P)object5).decl();
                                decl = ((P)object5).def();
                                if (!(decl instanceof DataDef)) {
                                    n2 = 4;
                                    continue block47;
                                }
                                DataDef $$ = (DataDef)decl;
                                defKind = HighlightInfo.DefKind.Data;
                                break block46;
                            }
                            case 4: {
                                Object object6 = object;
                                Decl $ = decl = ((P)object6).decl();
                                decl = ((P)object6).def();
                                if (!(decl instanceof CtorDef)) {
                                    n2 = 5;
                                    continue block47;
                                }
                                CtorDef $$ = (CtorDef)decl;
                                defKind = HighlightInfo.DefKind.Con;
                                break block46;
                            }
                            case 5: 
                        }
                        Object object7 = object;
                        Decl $ = decl = ((P)object7).decl();
                        decl = ((P)object7).def();
                        if (decl instanceof PrimDef) break;
                        n2 = 6;
                    }
                    PrimDef $$ = (PrimDef)decl;
                    defKind = HighlightInfo.DefKind.Prim;
                    break block46;
                }
                case 2: {
                    String string;
                    Object object = (LocalVar)anyVar2;
                    String $ = string = object.name();
                    String $$ = string = object.definition();
                    string = object.generateKind();
                    if (string instanceof GenerateKind.Generalized) {
                        GenerateKind.Generalized generalized = (GenerateKind.Generalized)string;
                        String $$$ = string = generalized.origin();
                    } else {
                        n = 3;
                        continue block46;
                    }
                    defKind = HighlightInfo.DefKind.Generalized;
                    break block46;
                }
                case 3: {
                    LocalVar ignored = (LocalVar)anyVar2;
                    defKind = HighlightInfo.DefKind.LocalVar;
                    break block46;
                }
                default: {
                    defKind = HighlightInfo.DefKind.Unknown;
                    break block46;
                }
            }
            break;
        }
        return defKind;
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }
}

