/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import kala.collection.immutable.ImmutableSeq;
import kala.text.StringSlice;
import org.aya.cli.literate.HighlightInfo;
import org.aya.pretty.doc.Link;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public record FlclToken(@NotNull SourcePos range, @NotNull Type type) {
    @NotNull
    public static final Link EMPTY_LINK = Link.page((String)"");

    @NotNull
    public HighlightInfo toInfo() {
        return switch (this.type) {
            default -> throw new RuntimeException(null, null);
            case Type.Keyword -> new HighlightInfo.Lit(this.range, HighlightInfo.LitKind.Keyword);
            case Type.Number -> new HighlightInfo.Lit(this.range, HighlightInfo.LitKind.Int);
            case Type.Comment -> new HighlightInfo.Lit(this.range, HighlightInfo.LitKind.Comment);
            case Type.Symbol -> new HighlightInfo.Lit(this.range, HighlightInfo.LitKind.SpecialSymbol);
            case Type.WhiteSpace -> new HighlightInfo.Lit(this.range, HighlightInfo.LitKind.Whitespace);
            case Type.Eol -> new HighlightInfo.Lit(this.range, HighlightInfo.LitKind.Eol);
            case Type.Fn -> this.createRef(HighlightInfo.DefKind.Fn);
            case Type.Data -> this.createRef(HighlightInfo.DefKind.Data);
            case Type.Constructor -> this.createRef(HighlightInfo.DefKind.Con);
            case Type.Primitive -> this.createRef(HighlightInfo.DefKind.Prim);
            case Type.Local -> this.createRef(HighlightInfo.DefKind.LocalVar);
        };
    }

    @NotNull
    private HighlightInfo.Ref createRef(@NotNull HighlightInfo.DefKind kind) {
        return new HighlightInfo.Ref(this.range, EMPTY_LINK, kind, null);
    }

    public static enum Type {
        Keyword,
        Fn,
        Data,
        Constructor,
        Primitive,
        Number,
        Local,
        Comment,
        WhiteSpace,
        Eol,
        Symbol;

    }

    public record File(@NotNull ImmutableSeq<FlclToken> tokens, @NotNull StringSlice sourceCode, int startIndex) {
    }
}

