/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.source;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.IntStream;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.value.MutableValue;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.utils.LiterateData;
import org.aya.concrete.GenericAyaFile;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.GenericDef;
import org.aya.generic.util.AyaFiles;
import org.aya.literate.Literate;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.ResolveInfo;
import org.aya.util.FileUtil;
import org.aya.util.error.SourceFile;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="displayPath()")
public record LibrarySource(@NotNull LibraryOwner owner, @NotNull Path underlyingFile, boolean isLiterate, @NotNull MutableList<LibrarySource> imports, @NotNull MutableValue<ImmutableSeq<Stmt>> program, @NotNull MutableValue<ImmutableSeq<GenericDef>> tycked, @NotNull MutableValue<ResolveInfo> resolveInfo, @NotNull MutableValue<LiterateData> literateData) implements GenericAyaFile
{
    @NotNull
    public static LibrarySource create(@NotNull LibraryOwner owner, @NotNull Path file) {
        Path underlyingFile = FileUtil.canonicalize((Path)file);
        return new LibrarySource(owner, underlyingFile, AyaFiles.isLiterate((Path)underlyingFile), (MutableList<LibrarySource>)MutableList.create(), (MutableValue<ImmutableSeq<Stmt>>)MutableValue.create(), (MutableValue<ImmutableSeq<GenericDef>>)MutableValue.create(), (MutableValue<ResolveInfo>)MutableValue.create(), (MutableValue<LiterateData>)MutableValue.create());
    }

    @NotNull
    public ImmutableSeq<String> moduleName() {
        ResolveInfo info = (ResolveInfo)this.resolveInfo.get();
        if (info != null) {
            return info.thisModule().modulePath().path();
        }
        Path display = this.displayPath();
        Path displayNoExt = display.resolveSibling(AyaFiles.stripAyaSourcePostfix((String)display.getFileName().toString()));
        return (ImmutableSeq)IntStream.range(0, displayNoExt.getNameCount()).mapToObj(i -> displayNoExt.getName(i).toString()).collect(ImmutableSeq.factory());
    }

    @NotNull
    public Path displayPath() {
        return this.owner.locator().displayName(this.underlyingFile);
    }

    public void notifyTycked(@NotNull ResolveInfo moduleResolve, @NotNull ImmutableSeq<GenericDef> tycked) {
        this.resolveInfo.set((Object)moduleResolve);
        this.tycked.set(tycked);
        if (this.isLiterate) {
            LiterateData data = (LiterateData)this.literateData.get();
            data.resolve(moduleResolve);
            data.tyck(moduleResolve);
        }
    }

    @NotNull
    public Doc pretty(@NotNull ImmutableSeq<Problem> problems, @NotNull PrettierOptions options) throws IOException {
        return LiterateData.toDoc(this, this.moduleName(), (ImmutableSeq<Stmt>)((ImmutableSeq)this.program.get()), problems, options);
    }

    @NotNull
    public ImmutableSeq<Stmt> parseMe(@NotNull GenericAyaParser parser) throws IOException {
        if (this.isLiterate) {
            LiterateData data = LiterateData.create(this.originalFile(), parser.reporter());
            data.parseMe(parser);
            this.literateData.set((Object)data);
        }
        ImmutableSeq stmts = super.parseMe(parser);
        this.program.set((Object)stmts);
        return stmts;
    }

    @NotNull
    public Literate literate() throws IOException {
        return this.isLiterate ? ((LiterateData)this.literateData.get()).literate() : super.literate();
    }

    @NotNull
    public SourceFile codeFile() throws IOException {
        return this.isLiterate ? ((LiterateData)this.literateData.get()).extractedAya() : super.codeFile();
    }

    @NotNull
    public SourceFile originalFile() throws IOException {
        return this.originalFile(Files.readString(this.underlyingFile));
    }

    @NotNull
    public SourceFile originalFile(@NotNull String sourceCode) {
        return new SourceFile(this.displayPath().toString(), this.underlyingFile, sourceCode);
    }

    @NotNull
    public Path compiledCorePath() {
        ImmutableSeq<String> mod = this.moduleName();
        return AyaFiles.resolveAyaCompiledFile((Path)this.owner.outDir(), mod);
    }

    @Override
    public String toString() {
        return this.underlyingFile.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibrarySource that = (LibrarySource)o;
        return this.owner.underlyingLibrary() == that.owner.underlyingLibrary() && this.underlyingFile.equals(that.underlyingFile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.owner.underlyingLibrary(), this.underlyingFile);
    }
}

