/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableSet;
import kala.function.CheckedRunnable;
import org.aya.cli.library.ImportResolver;
import org.aya.cli.library.LibraryModuleLoader;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.json.LibraryConfig;
import org.aya.cli.library.json.LibraryConfigData;
import org.aya.cli.library.source.DiskLibraryOwner;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.render.RenderOptions;
import org.aya.cli.single.CompilerFlags;
import org.aya.cli.utils.CliEnums;
import org.aya.cli.utils.CompilerUtil;
import org.aya.cli.utils.LiteratePrettierOptions;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.PrimDef;
import org.aya.generic.util.AyaFiles;
import org.aya.generic.util.InterruptException;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.printer.PrinterConfig;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.module.CachedModuleLoader;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.StringUtil;
import org.aya.util.error.InternalException;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.aya.util.terck.MutableGraph;
import org.aya.util.tyck.OrgaTycker;
import org.aya.util.tyck.SCCTycker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryCompiler {
    @NotNull
    private final LibraryOwner owner;
    @NotNull
    private final CachedModuleLoader<LibraryModuleLoader> moduleLoader;
    @NotNull
    private final CountingReporter reporter;
    @NotNull
    private final CompilerFlags flags;
    @NotNull
    private final CompilerAdvisor advisor;

    private LibraryCompiler(@NotNull Reporter reporter, @NotNull CompilerFlags flags, @NotNull LibraryOwner owner, @NotNull CompilerAdvisor advisor, @NotNull LibraryModuleLoader.United states) {
        CountingReporter counting = CountingReporter.delegate((Reporter)reporter);
        this.advisor = advisor;
        this.moduleLoader = new CachedModuleLoader((ModuleLoader)new LibraryModuleLoader(counting, owner, advisor, states));
        this.reporter = counting;
        this.flags = flags;
        this.owner = owner;
    }

    @NotNull
    public static LibraryCompiler newCompiler(@NotNull PrimDef.Factory primFactory, @NotNull Reporter reporter, @NotNull CompilerFlags flags, @NotNull CompilerAdvisor advisor, @NotNull LibraryOwner owner) {
        return new LibraryCompiler(reporter, flags, owner, advisor, new LibraryModuleLoader.United(primFactory));
    }

    @NotNull
    public static LibraryCompiler newCompiler(@NotNull PrimDef.Factory primFactory, @NotNull Reporter reporter, @NotNull CompilerFlags flags, @NotNull CompilerAdvisor advisor, @NotNull Path libraryRoot) throws IOException, LibraryConfigData.BadConfig {
        LibraryConfig config = LibraryConfigData.fromLibraryRoot(libraryRoot);
        DiskLibraryOwner owner = DiskLibraryOwner.from(config);
        return LibraryCompiler.newCompiler(primFactory, reporter, flags, advisor, owner);
    }

    public static int compile(@NotNull PrimDef.Factory primFactory, @NotNull Reporter reporter, @NotNull CompilerFlags flags, @NotNull CompilerAdvisor advisor, @NotNull Path libraryRoot) throws IOException {
        if (!Files.exists(libraryRoot, new LinkOption[0])) {
            reporter.reportString("Specified library root does not exist: " + String.valueOf(libraryRoot));
            return 1;
        }
        try {
            return LibraryCompiler.newCompiler(primFactory, reporter, flags, advisor, libraryRoot).start();
        }
        catch (LibraryConfigData.BadConfig bad) {
            reporter.reportString("Cannot load malformed library: " + bad.getMessage());
            return 1;
        }
    }

    private void parse(@NotNull LibrarySource source) throws IOException {
        source.parseMe(this.advisor.createParser((Reporter)this.reporter));
    }

    private boolean parseIfNeeded(@NotNull LibrarySource source) throws IOException {
        if (source.program().get() != null) {
            return true;
        }
        this.parse(source);
        return false;
    }

    private void resolveImportsIfNeeded(@NotNull LibrarySource source) throws IOException {
        if (this.parseIfNeeded(source)) {
            return;
        }
        ImportResolver finder = new ImportResolver((mod, sourcePos) -> {
            LibrarySource recurse = this.owner.findModule((ImmutableSeq<String>)mod.path());
            if (recurse == null) {
                this.reporter.report((Problem)new NameProblem.ModNotFoundError(mod, sourcePos));
                throw new Context.ResolvingInterruptedException();
            }
            return recurse;
        }, source);
        finder.resolveStmt((SeqLike<Stmt>)((SeqLike)source.program().get()));
    }

    @NotNull
    private MutableGraph<LibrarySource> resolveImports() throws IOException {
        MutableGraph depGraph = MutableGraph.create();
        this.reportNest("[Info] Resolving source file dependency");
        long startTime = System.currentTimeMillis();
        this.owner.librarySources().forEachChecked(src -> {
            this.resolveImportsIfNeeded((LibrarySource)src);
            MutableList known = depGraph.sucMut(src);
            ImmutableSeq dedup = src.imports().filter(s -> known.noneMatch(k -> k.moduleName().equals(s.moduleName())));
            known.appendAll((Iterable)dedup);
        });
        this.reporter.reportNest("Done in " + StringUtil.timeToString((long)(System.currentTimeMillis() - startTime)), 4);
        return depGraph;
    }

    public int start() throws IOException {
        if (this.flags.modulePaths().isNotEmpty()) {
            this.reporter.reportString("Warning: command-line specified module path (--module-path) is ignored when compiling libraries.");
        }
        if (this.flags.outputFile() != null) {
            this.reporter.reportString("Warning: command-line specified output file (-o, --output) is ignored when compiling libraries.");
        }
        return CompilerUtil.catching(this.reporter, this.flags, (CheckedRunnable<IOException>)((CheckedRunnable)this::make));
    }

    private void pretty(ImmutableSeq<LibrarySource> modified) throws IOException {
        CompilerFlags.PrettyInfo cmdPretty = this.flags.prettyInfo();
        if (cmdPretty == null) {
            return;
        }
        if (cmdPretty.prettyStage() != CliEnums.PrettyStage.literate) {
            this.reporter.reportString("Warning: only 'literate' pretty stage is supported when compiling libraries.");
            return;
        }
        this.reportNest("[Info] Generating literate output");
        final LibraryConfig.LibraryLiterateConfig litConfig = this.owner.underlyingLibrary().literateConfig();
        Path outputDir = cmdPretty.prettyDir() != null ? Files.createDirectories(Path.of(cmdPretty.prettyDir(), new String[0]), new FileAttribute[0]) : Files.createDirectories(litConfig.outputPath(), new FileAttribute[0]);
        LiteratePrettierOptions litPretty = litConfig.pretty();
        AyaPrettierOptions prettierOptions = litPretty != null ? litPretty.prettierOptions : cmdPretty.prettierOptions();
        RenderOptions renderOptions = litPretty != null ? litPretty.renderOptions : cmdPretty.renderOptions();
        final RenderOptions.OutputTarget outputTarget = cmdPretty.prettyFormat().target;
        RenderOptions.BackendSetup setup = cmdPretty.backendOpts(true).then(new RenderOptions.BackendSetup(){

            @Override
            @NotNull
            public <T extends PrinterConfig.Basic<?>> T setup(@NotNull T config) {
                config.set((PrinterConfig.Options)StringPrinterConfig.LinkOptions.CrossLinkPrefix, (Object)litConfig.linkPrefix());
                config.set((PrinterConfig.Options)StringPrinterConfig.LinkOptions.CrossLinkSeparator, (Object)"/");
                config.set((PrinterConfig.Options)StringPrinterConfig.LinkOptions.CrossLinkPostfix, (Object)(switch (outputTarget) {
                    case RenderOptions.OutputTarget.AyaMd, RenderOptions.OutputTarget.HTML -> ".html";
                    default -> "";
                }));
                return config;
            }
        });
        modified.forEachChecked(arg_0 -> LibraryCompiler.lambda$pretty$4((PrettierOptions)prettierOptions, renderOptions, outputTarget, setup, outputDir, arg_0));
    }

    private boolean make() throws IOException {
        LibraryConfig library = this.owner.underlyingLibrary();
        boolean anyDepChanged = false;
        for (LibraryOwner dep : this.owner.libraryDeps()) {
            LibraryCompiler depCompiler = new LibraryCompiler((Reporter)this.reporter, this.flags, dep, this.advisor, ((LibraryModuleLoader)this.moduleLoader.loader).states());
            boolean upToDate = depCompiler.make();
            anyDepChanged = anyDepChanged || !upToDate;
            this.owner.addModulePath(dep.outDir());
        }
        this.reporter.reportString("Compiling " + library.name());
        long startTime = System.currentTimeMillis();
        if (anyDepChanged || this.flags.remake()) {
            this.owner.librarySources().forEach(this::clearModified);
            this.advisor.clearLibraryOutput(this.owner);
        }
        Path srcRoot = library.librarySrcRoot();
        this.owner.addModulePath(srcRoot);
        ImmutableSeq<LibrarySource> modified = this.collectModified();
        if (modified.isEmpty()) {
            this.reportNest("[Info] No changes detected, no need to remake");
            return true;
        }
        boolean make = this.make(modified);
        this.reporter.reportNest("Library loaded in " + StringUtil.timeToString((long)(System.currentTimeMillis() - startTime)), 4);
        this.pretty(modified);
        return make;
    }

    private boolean make(@NotNull ImmutableSeq<LibrarySource> modified) throws IOException {
        modified.forEach(this::clearModified);
        MutableGraph<LibrarySource> depGraph = this.resolveImports();
        MutableGraph<LibrarySource> affected = LibraryCompiler.collectAffected(modified, depGraph);
        ImmutableSeq SCCs = affected.topologicalOrder().view().reversed().toImmutableSeq();
        SCCs.forEachChecked(i -> i.forEachChecked(this::reparseAffected));
        this.advisor.prepareLibraryOutput(this.owner);
        this.advisor.notifyIncrementalJob(modified, (ImmutableSeq<ImmutableSeq<LibrarySource>>)SCCs);
        LibraryOrgaTycker tycker = new LibraryOrgaTycker(new LibrarySccTycker(this.reporter, (ModuleLoader)this.moduleLoader, this.advisor), affected);
        SCCs.forEachChecked(arg_0 -> ((LibraryOrgaTycker)tycker).tyckSCC(arg_0));
        if (tycker.skippedSet.isNotEmpty()) {
            this.reporter.reportString("I dislike the following module(s):");
            tycker.skippedSet.forEach(f -> this.reportNest(String.format("%s (%s)", QualifiedID.join(f.moduleName()), f.displayPath())));
            throw new LibraryTyckingFailed();
        }
        this.reporter.reportString("I like these modules :)");
        return false;
    }

    private void reparseAffected(@NotNull LibrarySource src) throws IOException {
        if (src.tycked().get() == null) {
            return;
        }
        src.tycked().set(null);
        src.resolveInfo().set(null);
        src.literateData().set(null);
        this.clearPrimitives((ImmutableSeq<Stmt>)((ImmutableSeq)src.program().get()));
        this.parse(src);
    }

    private void clearModified(@NotNull LibrarySource src) {
        this.clearPrimitives((ImmutableSeq<Stmt>)((ImmutableSeq)src.program().get()));
        src.program().set(null);
        src.tycked().set(null);
        src.resolveInfo().set(null);
        src.literateData().set(null);
        src.imports().clear();
    }

    @NotNull
    private static MutableGraph<LibrarySource> collectAffected(@NotNull ImmutableSeq<LibrarySource> modified, @NotNull MutableGraph<LibrarySource> depGraph) {
        MutableGraph usageGraph = depGraph.transpose();
        MutableGraph affectedUsage = MutableGraph.create();
        modified.forEach(aff -> LibraryCompiler.collectAffected((MutableGraph<LibrarySource>)usageGraph, aff, (MutableGraph<LibrarySource>)affectedUsage));
        return affectedUsage;
    }

    private static void collectAffected(@NotNull MutableGraph<LibrarySource> usageGraph, @NotNull LibrarySource affected, @NotNull MutableGraph<LibrarySource> affectedUsage) {
        if (affectedUsage.E().containsKey((Object)affected)) {
            return;
        }
        SeqView suc = usageGraph.suc((Object)affected);
        affectedUsage.sucMut((Object)affected).appendAll((Iterable)suc);
        suc.forEach(dep -> LibraryCompiler.collectAffected(usageGraph, dep, affectedUsage));
    }

    @NotNull
    private ImmutableSeq<LibrarySource> collectModified() {
        return this.owner.librarySources().filter(this.advisor::isSourceModified).toImmutableSeq();
    }

    private void clearPrimitives(@Nullable ImmutableSeq<Stmt> stmts) {
        if (stmts == null) {
            return;
        }
        PrimitiveCleaner.clear(((LibraryModuleLoader)this.moduleLoader.loader).states().primFactory(), stmts);
    }

    private void reportNest(@NotNull String text) {
        this.reporter.reportNest(text, 2);
    }

    @NotNull
    public LibraryOwner libraryOwner() {
        return this.owner;
    }

    private static /* synthetic */ void lambda$pretty$4(PrettierOptions prettierOptions, RenderOptions renderOptions, RenderOptions.OutputTarget outputTarget, RenderOptions.BackendSetup setup, Path outputDir, LibrarySource src) throws IOException {
        Doc doc = src.pretty((ImmutableSeq<Problem>)ImmutableSeq.empty(), prettierOptions);
        String text = renderOptions.render(outputTarget, doc, setup);
        String outputFileName = AyaFiles.stripAyaSourcePostfix((String)src.displayPath().toString()) + outputTarget.fileExt;
        Path outputFile = outputDir.resolve(outputFileName);
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        Files.writeString(outputFile, (CharSequence)text, new OpenOption[0]);
    }

    static final class LibraryOrgaTycker
    extends Record
    implements OrgaTycker<LibrarySource, IOException> {
        @NotNull
        private final LibrarySccTycker sccTycker;
        @NotNull
        private final MutableGraph<LibrarySource> usageGraph;
        @NotNull
        private final MutableSet<LibrarySource> skippedSet;

        public LibraryOrgaTycker(@NotNull LibrarySccTycker sccTycker, @NotNull MutableGraph<LibrarySource> usage) {
            this(sccTycker, usage, (MutableSet<LibrarySource>)MutableSet.create());
        }

        LibraryOrgaTycker(@NotNull LibrarySccTycker sccTycker, @NotNull MutableGraph<LibrarySource> usageGraph, @NotNull MutableSet<LibrarySource> skippedSet) {
            this.sccTycker = sccTycker;
            this.usageGraph = usageGraph;
            this.skippedSet = skippedSet;
        }

        @NotNull
        public Iterable<LibrarySource> collectUsageOf(@NotNull LibrarySource failed) {
            return this.usageGraph.suc((Object)failed);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LibraryOrgaTycker.class, "sccTycker;usageGraph;skippedSet", "sccTycker", "usageGraph", "skippedSet"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LibraryOrgaTycker.class, "sccTycker;usageGraph;skippedSet", "sccTycker", "usageGraph", "skippedSet"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LibraryOrgaTycker.class, "sccTycker;usageGraph;skippedSet", "sccTycker", "usageGraph", "skippedSet"}, this, o);
        }

        @NotNull
        public LibrarySccTycker sccTycker() {
            return this.sccTycker;
        }

        @NotNull
        public MutableGraph<LibrarySource> usageGraph() {
            return this.usageGraph;
        }

        @NotNull
        public MutableSet<LibrarySource> skippedSet() {
            return this.skippedSet;
        }
    }

    record LibrarySccTycker(@NotNull CountingReporter reporter, @NotNull ModuleLoader moduleLoader, @NotNull CompilerAdvisor advisor) implements SCCTycker<LibrarySource, IOException>
    {
        @NotNull
        public ImmutableSeq<LibrarySource> tyckSCC(@NotNull ImmutableSeq<LibrarySource> order) throws IOException {
            for (LibrarySource f : order) {
                this.advisor.clearModuleOutput(f);
            }
            for (LibrarySource f : order) {
                this.tyckOne(f);
                if (!this.reporter.anyError()) continue;
                this.reporter.clear();
                return ImmutableSeq.of((Object)f);
            }
            return ImmutableSeq.empty();
        }

        private void tyckOne(@NotNull LibrarySource file) {
            ImmutableSeq<String> moduleName = file.moduleName();
            this.reporter.reportNest("[Tyck] %s (%s)".formatted(QualifiedID.join(moduleName), file.displayPath()), 2);
            ResolveInfo mod = this.moduleLoader.load(moduleName);
            if (mod == null || file.resolveInfo().get() == null) {
                throw new InternalException("Unable to load module: " + String.valueOf(moduleName));
            }
        }
    }

    public static class LibraryTyckingFailed
    extends InterruptException {
        public InterruptException.InterruptStage stage() {
            return InterruptException.InterruptStage.Tycking;
        }
    }

    static interface PrimitiveCleaner {
        public static void clear(@NotNull PrimDef.Factory factory, @NotNull ImmutableSeq<Stmt> stmts) {
            stmts.forEach(s -> PrimitiveCleaner.clear(factory, s));
        }

        public static void clear(@NotNull PrimDef.Factory factory, @NotNull Stmt stmt) {
            Stmt stmt2 = stmt;
            Objects.requireNonNull(stmt2);
            Stmt stmt3 = stmt2;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, TeleDecl.PrimDecl.class}, (Object)stmt3, n)) {
                    case 0: {
                        Command.Module mod = (Command.Module)stmt3;
                        PrimitiveCleaner.clear(factory, (ImmutableSeq<Stmt>)mod.contents());
                        break block4;
                    }
                    case 1: {
                        TeleDecl.PrimDecl decl = (TeleDecl.PrimDecl)stmt3;
                        if (decl.ref.core == null) {
                            n = 2;
                            continue block4;
                        }
                        factory.clear(((PrimDef)decl.ref.core).id);
                        break block4;
                    }
                }
                break;
            }
        }
    }
}

