/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.render.vscode;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.mutable.MutableMap;
import kala.control.Either;
import kala.control.Option;
import kala.control.Try;
import kala.value.LazyValue;
import org.aya.cli.render.Color;
import org.aya.cli.render.adapter.EitherAdapter;
import org.aya.cli.render.vscode.VscColorTheme;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorTheme {
    @Nullable
    public final Path include;
    @NotNull
    public final ImmutableMap<String, VscColorTheme.TokenColor.Settings> colorTheme;
    public final Option<LazyValue<Try<ColorTheme>>> parent;

    public static Try<ColorTheme> loadFrom(@NotNull Path path) throws JsonParseException {
        return Try.of(() -> {
            VscColorTheme jsonObj = (VscColorTheme)ColorTheme.newGsonBuilder().setLenient().create().fromJson((Reader)Files.newBufferedReader(path), VscColorTheme.class);
            String include = jsonObj.include;
            ImmutableMap<String, VscColorTheme.TokenColor.Settings> colorTheme = jsonObj.buildMap();
            Path includePath = null;
            if (include != null && !(includePath = Paths.get(include, new String[0])).isAbsolute()) {
                includePath = path.resolveSibling(includePath);
            }
            return new ColorTheme(includePath, colorTheme);
        });
    }

    @NotNull
    public static GsonBuilder newGsonBuilder() {
        return new GsonBuilder().registerTypeAdapter(Color.class, (Object)new Color.Adapter()).registerTypeAdapter(Either.class, (Object)new EitherAdapter());
    }

    public ColorTheme(@Nullable Path include, @NotNull ImmutableMap<String, VscColorTheme.TokenColor.Settings> colorTheme) {
        this.include = include;
        this.colorTheme = colorTheme;
        this.parent = include != null ? Option.some((Object)LazyValue.of(() -> ColorTheme.loadFrom(include))) : Option.none();
    }

    public Option<VscColorTheme.TokenColor.Settings> find(@NotNull String scope) {
        Option settings = this.colorTheme.getOption((Object)scope);
        if (settings.isEmpty() && this.parent.isDefined()) {
            LazyValue parent = (LazyValue)this.parent.get();
            return ((Try)parent.get()).toResult().toOption().flatMap(x -> x.find(scope));
        }
        return settings;
    }

    @NotNull
    public ColorScheme buildColorScheme(@Nullable ColorScheme fallback) {
        MutableMap builder = MutableMap.create();
        Map fallbackColors = fallback == null ? Map.empty() : fallback.definedColors();
        this.findAndPut((MutableMap<String, Integer>)builder, AyaStyleKey.Keyword.key(), VscColorTheme.SCOPE_KEYWORD, (Map<String, Integer>)fallbackColors);
        this.findAndPut((MutableMap<String, Integer>)builder, AyaStyleKey.Fn.key(), VscColorTheme.SCOPE_FN_CALL, (Map<String, Integer>)fallbackColors);
        this.findAndPut((MutableMap<String, Integer>)builder, AyaStyleKey.Generalized.key(), VscColorTheme.SCOPE_GENERALIZED, (Map<String, Integer>)fallbackColors);
        this.findAndPut((MutableMap<String, Integer>)builder, AyaStyleKey.Data.key(), VscColorTheme.SCOPE_DATA_CALL, (Map<String, Integer>)fallbackColors);
        this.findAndPut((MutableMap<String, Integer>)builder, AyaStyleKey.Clazz.key(), VscColorTheme.SCOPE_STRUCT_CALL, (Map<String, Integer>)fallbackColors);
        this.findAndPut((MutableMap<String, Integer>)builder, AyaStyleKey.Con.key(), VscColorTheme.SCOPE_CON_CALL, (Map<String, Integer>)fallbackColors);
        this.findAndPut((MutableMap<String, Integer>)builder, AyaStyleKey.Member.key(), VscColorTheme.SCOPE_FIELD_CALL, (Map<String, Integer>)fallbackColors);
        return new AyaColorScheme(builder);
    }

    public void findAndPut(@NotNull MutableMap<String, Integer> putTo, @NotNull String key, @NotNull Seq<String> scope, @NotNull Map<String, Integer> fallback) {
        Option fallbackValue;
        Option result = scope.view().map(this::find).firstOption(Option::isDefined);
        if (result.isDefined()) {
            VscColorTheme.TokenColor.Settings settings = (VscColorTheme.TokenColor.Settings)((Option)result.get()).get();
            Color foreground = settings.foreground;
            if (foreground != null) {
                putTo.put((Object)key, (Object)foreground.color);
                return;
            }
        }
        if ((fallbackValue = fallback.getOption((Object)key)).isDefined()) {
            putTo.put((Object)key, (Object)((Integer)fallbackValue.get()));
        }
    }
}

