/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.render;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import kala.control.Either;
import org.aya.cli.render.vscode.ColorTheme;
import org.aya.pretty.backend.html.DocHtmlPrinter;
import org.aya.pretty.backend.html.Html5Stylist;
import org.aya.pretty.backend.latex.DocTeXPrinter;
import org.aya.pretty.backend.latex.TeXStylist;
import org.aya.pretty.backend.md.DocMdPrinter;
import org.aya.pretty.backend.md.MdStylist;
import org.aya.pretty.backend.string.DebugStylist;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.string.StringStylist;
import org.aya.pretty.backend.terminal.AdaptiveCliStylist;
import org.aya.pretty.backend.terminal.DocTermPrinter;
import org.aya.pretty.backend.terminal.UnixTermStylist;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.Printer;
import org.aya.pretty.printer.PrinterConfig;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class RenderOptions {
    @NotNull
    public static final ColorSchemeName DEFAULT_COLOR_SCHEME = ColorSchemeName.Emacs;
    @NotNull
    public static final StyleFamilyName DEFAULT_STYLE_FAMILY = StyleFamilyName.Default;
    public @UnknownNullability ColorSchemeName colorScheme = DEFAULT_COLOR_SCHEME;
    public @UnknownNullability StyleFamilyName styleFamily = DEFAULT_STYLE_FAMILY;
    @Nullable
    public String path = null;
    @Nullable
    private transient ColorScheme colorSchemeCache = null;
    @Nullable
    private transient StyleFamily styleFamilyCache = null;

    public void checkDeserialization() {
        if (this.colorScheme == null) {
            this.colorScheme = DEFAULT_COLOR_SCHEME;
        }
        if (this.styleFamily == null) {
            this.styleFamily = DEFAULT_STYLE_FAMILY;
        }
    }

    public boolean isDefault() {
        return this.colorScheme.equals((Object)DEFAULT_COLOR_SCHEME) && this.styleFamily.equals((Object)DEFAULT_STYLE_FAMILY);
    }

    @NotNull
    public String prettyColorScheme() {
        return this.colorScheme == ColorSchemeName.Custom ? Objects.requireNonNull(this.path) : this.colorScheme.toString();
    }

    @NotNull
    public String prettyStyleFamily() {
        return this.styleFamily.toString();
    }

    public void updateColorScheme(@NotNull Either<ColorSchemeName, Path> nameOrPath) throws IllegalArgumentException {
        if (nameOrPath.isLeft()) {
            ColorSchemeName color = (ColorSchemeName)((Object)nameOrPath.getLeftValue());
            if (color == ColorSchemeName.Custom) {
                throw new IllegalArgumentException("To set a custom color scheme, just give the path to it :)");
            }
            this.colorScheme = color;
        } else {
            this.colorScheme = ColorSchemeName.Custom;
            this.path = ((Path)nameOrPath.getRightValue()).toAbsolutePath().toString();
        }
        this.invalidate();
    }

    public void updateStyleFamily(@NotNull Either<StyleFamilyName, Path> nameOrPath) throws IllegalArgumentException {
        if (nameOrPath.isRight()) {
            throw new IllegalArgumentException("We don't support custom style family yet :)");
        }
        this.styleFamily = (StyleFamilyName)((Object)nameOrPath.getLeftValue());
        this.invalidate();
    }

    public void invalidate() {
        this.colorSchemeCache = null;
        this.styleFamilyCache = null;
    }

    @NotNull
    public static StringStylist defaultStylist(@NotNull OutputTarget output) {
        return switch (output) {
            default -> throw new RuntimeException(null, null);
            case OutputTarget.Unix -> AdaptiveCliStylist.INSTANCE;
            case OutputTarget.LaTeX -> TeXStylist.DEFAULT;
            case OutputTarget.KaTeX -> TeXStylist.DEFAULT_KATEX;
            case OutputTarget.AyaMd -> MdStylist.DEFAULT;
            case OutputTarget.HTML -> Html5Stylist.DEFAULT;
            case OutputTarget.Plain -> DebugStylist.DEFAULT;
        };
    }

    @NotNull
    public StringStylist stylist(@NotNull OutputTarget output) throws IOException, JsonParseException {
        if (this.isDefault()) {
            return RenderOptions.defaultStylist(output);
        }
        ColorScheme c = this.buildColorScheme();
        StyleFamily s = this.buildStyleFamily();
        return switch (output) {
            default -> throw new RuntimeException(null, null);
            case OutputTarget.Unix -> new UnixTermStylist(c, s);
            case OutputTarget.LaTeX -> new TeXStylist(c, s, false);
            case OutputTarget.KaTeX -> new TeXStylist(c, s, true);
            case OutputTarget.AyaMd -> new MdStylist(c, s);
            case OutputTarget.HTML -> new Html5Stylist(c, s);
            case OutputTarget.Plain -> new DebugStylist(c, s);
        };
    }

    @NotNull
    public StringStylist stylistOrDefault(@NotNull OutputTarget output) {
        try {
            return this.stylist(output);
        }
        catch (JsonParseException | IOException e) {
            return RenderOptions.defaultStylist(output);
        }
    }

    @NotNull
    public String render(@NotNull OutputTarget output, @NotNull Doc doc, @NotNull BackendSetup setup) {
        StringStylist stylist = this.stylistOrDefault(output);
        return switch (output) {
            default -> throw new RuntimeException(null, null);
            case OutputTarget.Plain -> doc.renderToString(setup.setup(new StringPrinterConfig(stylist)));
            case OutputTarget.LaTeX, OutputTarget.KaTeX -> (String)doc.render((Printer)new DocTeXPrinter(), (PrinterConfig)setup.setup(new DocTeXPrinter.Config((TeXStylist)stylist)));
            case OutputTarget.HTML -> (String)doc.render((Printer)new DocHtmlPrinter(), (PrinterConfig)setup.setup(new DocHtmlPrinter.Config((Html5Stylist)stylist)));
            case OutputTarget.AyaMd -> (String)doc.render((Printer)new DocMdPrinter(), (PrinterConfig)setup.setup(new DocMdPrinter.Config((MdStylist)stylist)));
            case OutputTarget.Unix -> (String)doc.render((Printer)new DocTermPrinter(), (PrinterConfig)setup.setup(new DocTermPrinter.Config((UnixTermStylist)stylist)));
        };
    }

    @NotNull
    private ColorScheme buildColorScheme() throws IOException, JsonParseException {
        if (this.colorSchemeCache != null) {
            return this.colorSchemeCache;
        }
        this.colorSchemeCache = switch (this.colorScheme) {
            default -> throw new RuntimeException(null, null);
            case ColorSchemeName.Emacs -> AyaColorScheme.EMACS;
            case ColorSchemeName.IntelliJ -> AyaColorScheme.INTELLIJ;
            case ColorSchemeName.Custom -> {
                if (this.path == null) {
                    throw new IllegalArgumentException("Unable to generate a custom color scheme without a path");
                }
                ColorTheme colorTheme = (ColorTheme)ColorTheme.loadFrom(Path.of(this.path, new String[0])).getOrThrow();
                yield colorTheme.buildColorScheme(null);
            }
        };
        return this.colorSchemeCache;
    }

    @NotNull
    private StyleFamily buildStyleFamily() {
        if (this.styleFamilyCache != null) {
            return this.styleFamilyCache;
        }
        switch (this.styleFamily) {
            default: {
                throw new RuntimeException(null, null);
            }
            case Default: 
        }
        this.styleFamilyCache = AyaStyleFamily.DEFAULT;
        return this.styleFamilyCache;
    }

    public void doBadThing(ColorScheme colorSchemeCache, StyleFamily styleFamilyCache) {
        this.colorSchemeCache = colorSchemeCache;
        this.styleFamilyCache = styleFamilyCache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenderOptions)) {
            return false;
        }
        RenderOptions that = (RenderOptions)o;
        return this.colorScheme == that.colorScheme && this.styleFamily == that.styleFamily && Objects.equals(this.path, that.path);
    }

    public static enum ColorSchemeName {
        Emacs,
        IntelliJ,
        Custom;

    }

    public static enum StyleFamilyName {
        Default;

    }

    public static enum OutputTarget {
        Unix(".txt"),
        LaTeX(".tex"),
        KaTeX(".katex"),
        AyaMd(".md"),
        HTML(".html"),
        Plain(".txt");

        @NotNull
        @NonNls
        public final String fileExt;

        private OutputTarget(String fileExt) {
            this.fileExt = fileExt;
        }
    }

    public static interface BackendSetup {
        @NotNull
        public <T extends PrinterConfig.Basic<?>> T setup(@NotNull T var1);

        @NotNull
        default public BackendSetup then(@NotNull BackendSetup next) {
            return new ChainedSetup(this, next);
        }
    }

    public record DefaultSetup(boolean headerCode, boolean styleCode, boolean separateStyle, boolean unicode, int pageWidth, boolean SSR) implements BackendSetup
    {
        @Override
        @NotNull
        public <T extends PrinterConfig.Basic<?>> T setup(@NotNull T config) {
            config.set((PrinterConfig.Options)PrinterConfig.PageOptions.PageWidth, (Object)this.pageWidth);
            config.set((PrinterConfig.Options)StringPrinterConfig.TextOptions.Unicode, (Object)this.unicode);
            config.set((PrinterConfig.Options)StringPrinterConfig.StyleOptions.HeaderCode, (Object)this.headerCode);
            config.set((PrinterConfig.Options)StringPrinterConfig.StyleOptions.StyleCode, (Object)this.styleCode);
            config.set((PrinterConfig.Options)StringPrinterConfig.StyleOptions.SeparateStyle, (Object)this.separateStyle);
            config.set((PrinterConfig.Options)StringPrinterConfig.StyleOptions.AyaFlavored, (Object)true);
            config.set((PrinterConfig.Options)StringPrinterConfig.StyleOptions.ServerSideRendering, (Object)this.SSR);
            return config;
        }
    }

    public record ChainedSetup(@NotNull BackendSetup first, @NotNull BackendSetup second) implements BackendSetup
    {
        @Override
        @NotNull
        public <T extends PrinterConfig.Basic<?>> T setup(@NotNull T config) {
            return this.second.setup(this.first.setup(config));
        }
    }
}

