/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.parse;

import com.intellij.psi.tree.IElementType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Predicate;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.parse.ModifierProblem;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.DeclInfo;
import org.aya.parser.AyaPsiElementTypes;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ModifierParser(@NotNull Reporter reporter) {
    public static final Filter DECL_FILTER = Filter.create((WithPos<Stmt.Accessibility>)new WithPos(SourcePos.NONE, (Object)Stmt.Accessibility.Public), (WithPos<DeclInfo.Personality>)new WithPos(SourcePos.NONE, (Object)DeclInfo.Personality.NORMAL), EnumSet.of(Modifier.Open));
    public static final Filter FN_FILTER = Filter.create((WithPos<Stmt.Accessibility>)new WithPos(SourcePos.NONE, (Object)Stmt.Accessibility.Public), (WithPos<DeclInfo.Personality>)new WithPos(SourcePos.NONE, (Object)DeclInfo.Personality.NORMAL), EnumSet.of(Modifier.Opaque, Modifier.Inline, Modifier.Overlap));
    public static final Filter SUBDECL_FILTER = Filter.create((WithPos<Stmt.Accessibility>)new WithPos(SourcePos.NONE, (Object)Stmt.Accessibility.Public), (WithPos<DeclInfo.Personality>)new WithPos(SourcePos.NONE, (Object)DeclInfo.Personality.NORMAL), EnumSet.noneOf(Modifier.class)).and(x -> false);

    @NotNull
    private ImmutableSeq<WithPos<Modifier>> implication(@NotNull ImmutableSeq<WithPos<Modifier>> modifiers) {
        return ((ImmutableMap)modifiers.view().flatMap(modi -> Seq.from((Object[])((Modifier)((Object)((Object)modi.data()))).implies).map(imply -> new WithPos(modi.sourcePos(), (Object)imply))).collect(ImmutableMap.collector(WithPos::data, x -> x))).valuesView().toImmutableSeq();
    }

    @NotNull
    public Modifiers parse(@NotNull ImmutableSeq<WithPos<Modifier>> modifiers, @NotNull Filter filter) {
        EnumMap<ModifierGroup, EnumMap> map = new EnumMap<ModifierGroup, EnumMap>(ModifierGroup.class);
        modifiers = this.implication(modifiers).concat(modifiers);
        for (WithPos data : modifiers) {
            SourcePos pos = data.sourcePos();
            Modifier modifier = (Modifier)((Object)data.data());
            if (!filter.available.test((Modifier)((Object)data.data()))) {
                this.reportUnsuitableModifier((WithPos<Modifier>)data);
                continue;
            }
            map.computeIfAbsent(modifier.group, k -> new EnumMap(Modifier.class));
            EnumMap exists = (EnumMap)map.get((Object)modifier.group);
            if (exists.containsKey((Object)modifier)) {
                this.reportDuplicatedModifier((WithPos<Modifier>)data);
                continue;
            }
            if (modifier.group != ModifierGroup.None && !exists.isEmpty() && !exists.containsKey((Object)modifier)) {
                assert (exists.size() == 1);
                Map.Entry contradict = (Map.Entry)Seq.from(exists.entrySet()).first();
                this.reportContradictModifier((WithPos<Modifier>)data, (WithPos<Modifier>)new WithPos((SourcePos)contradict.getValue(), (Object)((Modifier)((Object)contradict.getKey()))));
                continue;
            }
            exists.put(modifier, pos);
        }
        return new ModifierSet((ImmutableMap<Modifier, SourcePos>)ImmutableMap.from((Iterable)ImmutableSeq.from(map.values()).flatMap(EnumMap::entrySet)), filter.defaultMods);
    }

    public void reportUnsuitableModifier(@NotNull WithPos<Modifier> data) {
        this.reporter.report((Problem)new ModifierProblem(data.sourcePos(), (Modifier)((Object)data.data()), ModifierProblem.Reason.Inappropriate));
    }

    public void reportDuplicatedModifier(@NotNull WithPos<Modifier> data) {
        this.reporter.report((Problem)new ModifierProblem(data.sourcePos(), (Modifier)((Object)data.data()), ModifierProblem.Reason.Duplicative));
    }

    public void reportContradictModifier(@NotNull WithPos<Modifier> current, @NotNull WithPos<Modifier> that) {
        this.reporter.report((Problem)new ModifierProblem(current.sourcePos(), (Modifier)((Object)current.data()), ModifierProblem.Reason.Contradictory));
    }

    public static enum ModifierGroup {
        None,
        Accessibility,
        Personality,
        Alpha;

    }

    public static enum Modifier {
        Private(AyaPsiElementTypes.KW_PRIVATE, ModifierGroup.Accessibility, "private", new Modifier[0]),
        Example(AyaPsiElementTypes.KW_EXAMPLE, ModifierGroup.Personality, "example", Private),
        Counterexample(AyaPsiElementTypes.KW_COUNTEREXAMPLE, ModifierGroup.Personality, "counterexample", Private),
        Open(AyaPsiElementTypes.OPEN_KW, ModifierGroup.None, "open", new Modifier[0]),
        Opaque(AyaPsiElementTypes.KW_OPAQUE, ModifierGroup.Alpha, "opaque", new Modifier[0]),
        Inline(AyaPsiElementTypes.KW_INLINE, ModifierGroup.Alpha, "inline", new Modifier[0]),
        Overlap(AyaPsiElementTypes.KW_OVERLAP, ModifierGroup.None, "overlap", new Modifier[0]);

        @NotNull
        public final IElementType type;
        @NotNull
        public final ModifierGroup group;
        @NotNull
        public final String keyword;
        @NotNull
        public final Modifier[] implies;

        private Modifier(@NotNull IElementType type, @NotNull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotNull @NotNull ModifierGroup group, String keyword, Modifier ... implies) {
            this.type = type;
            this.group = group;
            this.keyword = keyword;
            this.implies = implies;
        }
    }

    public record Filter(@NotNull Modifiers defaultMods, @NotNull Predicate<Modifier> available) {
        @NotNull
        public Filter and(@NotNull Predicate<Modifier> and) {
            return new Filter(this.defaultMods, this.available.and(and));
        }

        @NotNull
        public static Filter create(@NotNull WithPos<Stmt.Accessibility> defaultAcc, @NotNull WithPos<DeclInfo.Personality> defaultPer, @NotNull EnumSet<Modifier> miscAvail) {
            return new Filter(new DefaultModifiers(defaultAcc, defaultPer, miscAvail), mod -> switch (mod) {
                default -> throw new RuntimeException(null, null);
                case Modifier.Private, Modifier.Example, Modifier.Counterexample -> true;
                case Modifier.Open, Modifier.Opaque, Modifier.Inline, Modifier.Overlap -> miscAvail.contains(mod);
            });
        }
    }

    private record ModifierSet(@NotNull ImmutableMap<Modifier, SourcePos> mods, @NotNull Modifiers parent) implements Modifiers
    {
        @Override
        @Contract(pure=true)
        @NotNull
        public WithPos<Stmt.Accessibility> accessibility() {
            return (WithPos)this.mods.getOption((Object)Modifier.Private).map(pos -> new WithPos(pos, (Object)Stmt.Accessibility.Private)).getOrElse(this.parent::accessibility);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public WithPos<DeclInfo.Personality> personality() {
            if (this.mods.containsKey((Object)Modifier.Example)) {
                return new WithPos((SourcePos)this.mods.get((Object)Modifier.Example), (Object)DeclInfo.Personality.EXAMPLE);
            }
            if (this.mods.containsKey((Object)Modifier.Counterexample)) {
                return new WithPos((SourcePos)this.mods.get((Object)Modifier.Counterexample), (Object)DeclInfo.Personality.COUNTEREXAMPLE);
            }
            return this.parent.personality();
        }

        @Override
        @Nullable
        public SourcePos misc(@NotNull Modifier key) {
            return (SourcePos)this.mods.getOrElse((Object)key, () -> this.parent.misc(key));
        }
    }

    public static interface Modifiers {
        @Contract(pure=true)
        @NotNull
        public WithPos<Stmt.Accessibility> accessibility();

        @Contract(pure=true)
        @NotNull
        public WithPos<DeclInfo.Personality> personality();

        @Contract(pure=true)
        @Nullable
        public SourcePos misc(@NotNull Modifier var1);

        @NotNull
        default public EnumSet<org.aya.generic.Modifier> toFnModifiers() {
            EnumSet<org.aya.generic.Modifier> fnMods = EnumSet.noneOf(org.aya.generic.Modifier.class);
            if (this.misc(Modifier.Inline) != null) {
                fnMods.add(org.aya.generic.Modifier.Inline);
            }
            if (this.misc(Modifier.Opaque) != null) {
                fnMods.add(org.aya.generic.Modifier.Opaque);
            }
            if (this.misc(Modifier.Overlap) != null) {
                fnMods.add(org.aya.generic.Modifier.Overlap);
            }
            return fnMods;
        }
    }

    record DefaultModifiers(@NotNull WithPos<Stmt.Accessibility> accessibility, @NotNull WithPos<DeclInfo.Personality> personality, @NotNull EnumSet<Modifier> miscAvail) implements Modifiers
    {
        @Override
        @Nullable
        public SourcePos misc(@NotNull Modifier key) {
            return null;
        }
    }
}

