/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.source;

import java.nio.file.Path;
import java.util.Iterator;
import kala.collection.CollectionView;
import kala.collection.SeqView;
import kala.collection.SetView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableSet;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableQueue;
import kala.collection.mutable.MutableSet;
import kala.tuple.Tuple;
import org.aya.cli.library.json.LibraryConfig;
import org.aya.cli.library.source.LibrarySource;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.terck.MutableGraph;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="underlyingLibrary().name()")
public interface LibraryOwner {
    public static final int DEFAULT_INDENT = 2;

    @NotNull
    public SeqView<Path> modulePath();

    @NotNull
    public SeqView<LibrarySource> librarySources();

    @NotNull
    public SeqView<LibraryOwner> libraryDeps();

    @NotNull
    public SourceFileLocator locator();

    @NotNull
    public LibraryConfig underlyingLibrary();

    public void addModulePath(@NotNull Path var1);

    @NotNull
    default public Path outDir() {
        return this.underlyingLibrary().libraryOutRoot();
    }

    @Nullable
    default public LibrarySource findModule(@NotNull ImmutableSeq<String> mod) {
        LibrarySource file;
        block1: {
            LibraryOwner dep;
            file = this.findModuleHere(mod);
            if (file != null) break block1;
            Iterator iterator = this.libraryDeps().iterator();
            while (iterator.hasNext() && (file = (dep = (LibraryOwner)iterator.next()).findModule(mod)) == null) {
            }
        }
        return file;
    }

    @Nullable
    private LibrarySource findModuleHere(@NotNull ImmutableSeq<String> mod) {
        return (LibrarySource)this.librarySources().find(s -> {
            ImmutableSeq<String> checkMod = s.moduleName();
            return checkMod.equals((Object)mod);
        }).getOrNull();
    }

    @NotNull
    public static ImmutableSet<LibraryOwner> collectDependencies(@NotNull LibraryOwner owner) {
        MutableSet libs = MutableSet.create();
        MutableQueue queue = MutableQueue.create();
        queue.enqueue((Object)owner);
        while (queue.isNotEmpty()) {
            LibraryOwner thisOwner = (LibraryOwner)queue.dequeue();
            if (libs.contains((Object)thisOwner)) continue;
            libs.add((Object)thisOwner);
            thisOwner.libraryDeps().forEach(arg_0 -> ((MutableQueue)queue).enqueue(arg_0));
        }
        return libs.toImmutableSet();
    }

    @NotNull
    public static MutableGraph<LibraryConfig> buildDependencyGraph(@NotNull LibraryOwner owner) {
        return LibraryOwner.buildDependencyGraph((SetView<LibraryOwner>)LibraryOwner.collectDependencies(owner).view());
    }

    @NotNull
    public static MutableGraph<LibraryConfig> buildDependencyGraph(@NotNull SetView<LibraryOwner> owners) {
        CollectionView edges = owners.map(owner -> Tuple.of((Object)owner.underlyingLibrary(), (Object)MutableList.from((Iterable)owner.libraryDeps().map(LibraryOwner::underlyingLibrary))));
        return new MutableGraph(MutableMap.from((Iterable)edges));
    }
}

