/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.interactive;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Either;
import kala.function.CheckedFunction;
import kala.value.MutableValue;
import org.aya.cli.interactive.ReplContext;
import org.aya.cli.interactive.ReplShapeFactory;
import org.aya.cli.library.LibraryCompiler;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.json.LibraryConfigData;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.parse.AyaParserImpl;
import org.aya.cli.single.CompilerFlags;
import org.aya.cli.single.SingleAyaFile;
import org.aya.concrete.Expr;
import org.aya.concrete.GenericAyaFile;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.desugar.Desugarer;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.PrimDef;
import org.aya.core.repr.AyaShape;
import org.aya.core.term.Term;
import org.aya.generic.util.InterruptException;
import org.aya.generic.util.NormalizeMode;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.ModulePath;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.module.CachedModuleLoader;
import org.aya.resolve.module.FileModuleLoader;
import org.aya.resolve.module.ModuleListLoader;
import org.aya.resolve.module.ModuleLoader;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.Result;
import org.aya.tyck.tycker.TyckState;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.DelayedReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplCompiler {
    @NotNull
    public final CountingReporter reporter;
    @NotNull
    private final SourceFileLocator locator;
    @NotNull
    private final CachedModuleLoader<ModuleListLoader> loader;
    @NotNull
    private final ReplContext context;
    @NotNull
    private final ImmutableSeq<Path> modulePaths;
    @NotNull
    private final PrimDef.Factory primFactory;
    @NotNull
    private final ReplShapeFactory shapeFactory;
    @NotNull
    private final GenericAyaFile.Factory fileManager;
    @NotNull
    private final AyaBinOpSet opSet;

    public ReplCompiler(@NotNull ImmutableSeq<Path> modulePaths, @NotNull Reporter reporter, @Nullable SourceFileLocator locator) {
        this.modulePaths = modulePaths;
        this.reporter = CountingReporter.delegate((Reporter)reporter);
        this.locator = locator != null ? locator : new SourceFileLocator.Module(this.modulePaths);
        this.primFactory = new PrimDef.Factory(this){

            public boolean suppressRedefinition() {
                return true;
            }
        };
        this.shapeFactory = new ReplShapeFactory();
        this.opSet = new AyaBinOpSet((Reporter)this.reporter);
        this.context = new ReplContext((Context)new EmptyContext((Reporter)this.reporter, Path.of("REPL", new String[0])), ModulePath.of((String[])new String[]{"REPL"}));
        this.fileManager = new SingleAyaFile.Factory((Reporter)this.reporter);
        AyaParserImpl parser = new AyaParserImpl((Reporter)this.reporter);
        this.loader = new CachedModuleLoader((ModuleLoader)new ModuleListLoader((Reporter)this.reporter, this.modulePaths.map(path -> new FileModuleLoader(this.locator, path, (Reporter)this.reporter, (GenericAyaParser)parser, this.fileManager, this.primFactory, null))));
    }

    @NotNull
    private Result tyckExpr(@NotNull Expr expr) {
        Expr resolvedExpr = expr.resolveLax((ModuleContext)this.context);
        try (DelayedReporter delayedReporter = new DelayedReporter((Reporter)this.reporter);){
            ExprTycker tycker = new ExprTycker(this.primFactory, (AyaShape.Factory)this.shapeFactory, (Reporter)delayedReporter, null);
            Expr desugar = this.desugarExpr(resolvedExpr, (Reporter)delayedReporter);
            Result result = tycker.zonk(tycker.synthesize(desugar));
            return result;
        }
    }

    @NotNull
    private Expr desugarExpr(@NotNull Expr expr, @NotNull Reporter reporter) {
        ResolveInfo resolveInfo = new ResolveInfo(this.primFactory, (AyaShape.Factory)this.shapeFactory, this.opSet, (ModuleContext)new EmptyContext(reporter, Path.of("dummy", new String[0])).derive("dummy"), ImmutableSeq.empty());
        return new Desugarer(resolveInfo).apply(expr);
    }

    public void loadToContext(@NotNull Path file) throws IOException {
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.loadLibrary(file);
        } else {
            this.loadFile(file);
        }
    }

    private void loadLibrary(@NotNull Path libraryRoot) throws IOException {
        CompilerFlags flags = new CompilerFlags(CompilerFlags.Message.EMOJI, false, true, null, (SeqLike<Path>)this.modulePaths.view(), null);
        try {
            LibraryCompiler compiler = LibraryCompiler.newCompiler(this.primFactory, (Reporter)this.reporter, flags, CompilerAdvisor.onDisk(), libraryRoot);
            compiler.start();
            LibraryOwner owner = compiler.libraryOwner();
            this.importModule(owner);
        }
        catch (LibraryConfigData.BadConfig bad) {
            this.reporter.reportString("Cannot load malformed library: " + bad.getMessage(), Problem.Severity.ERROR);
        }
    }

    private void importModule(@NotNull LibraryOwner owner) {
        owner.librarySources().map(src -> ((ResolveInfo)src.resolveInfo().get()).thisModule()).filterIsInstance(PhysicalModuleContext.class).forEach(mod -> this.context.importModule(mod.modulePath().asName(), (ModuleContext)mod, Stmt.Accessibility.Public, SourcePos.NONE));
        owner.libraryDeps().forEach(this::importModule);
    }

    private void loadFile(@NotNull Path file) {
        this.compileToContext((CheckedFunction<AyaParserImpl, Either<ImmutableSeq<Stmt>, Expr>, IOException>)((CheckedFunction)parser -> Either.left((Object)this.fileManager.createAyaFile(this.locator, file).parseMe((GenericAyaParser)parser))), NormalizeMode.WHNF);
    }

    @NotNull
    public Either<ImmutableSeq<GenericDef>, Term> compileToContext(@NotNull String text, @NotNull NormalizeMode normalizeMode) {
        if (text.isBlank()) {
            return Either.left((Object)ImmutableSeq.empty());
        }
        return this.compileToContext((CheckedFunction<AyaParserImpl, Either<ImmutableSeq<Stmt>, Expr>, IOException>)((CheckedFunction)parser -> parser.repl(text)), normalizeMode);
    }

    @NotNull
    public Either<ImmutableSeq<GenericDef>, Term> compileToContext(@NotNull CheckedFunction<AyaParserImpl, Either<ImmutableSeq<Stmt>, Expr>, IOException> parsing, @NotNull NormalizeMode normalizeMode) {
        try {
            AyaParserImpl parser = new AyaParserImpl((Reporter)this.reporter);
            Either programOrExpr = (Either)parsing.apply((Object)parser);
            return programOrExpr.map(program -> {
                MutableValue newDefs = MutableValue.create();
                ResolveInfo resolveInfo = this.loader.resolveModule(this.primFactory, (AyaShape.Factory)this.shapeFactory, this.opSet, (ModuleContext)this.context.fork(), program, this.loader);
                resolveInfo.shapeFactory().discovered = this.shapeFactory.fork().discovered;
                this.loader.tyckModule(null, resolveInfo, (moduleResolve, defs) -> newDefs.set((Object)defs));
                if (this.reporter.anyError()) {
                    return ImmutableSeq.empty();
                }
                this.context.merge();
                this.shapeFactory.merge();
                return (ImmutableSeq)newDefs.get();
            }, expr -> this.tyckExpr((Expr)expr).wellTyped().normalize(new TyckState(this.primFactory), normalizeMode));
        }
        catch (InterruptException ignored) {
            return Either.left((Object)ImmutableSeq.empty());
        }
    }

    @Nullable
    public Term computeType(@NotNull String text, @NotNull NormalizeMode normalizeMode) {
        try {
            Either<ImmutableSeq<Stmt>, Expr> parseTree = new AyaParserImpl((Reporter)this.reporter).repl(text);
            if (parseTree.isLeft()) {
                this.reporter.reportString("Expect expression, got statement", Problem.Severity.ERROR);
                return null;
            }
            return this.tyckExpr((Expr)parseTree.getRightValue()).type().normalize(new TyckState(this.primFactory), normalizeMode);
        }
        catch (InterruptException ignored) {
            return null;
        }
    }

    @Nullable
    public FnDef codificationObject(@NotNull String text) {
        Expr.Ref ref;
        Expr parseTree = new AyaParserImpl((Reporter)this.reporter).expr(text, SourcePos.NONE);
        Expr expr = parseTree.resolveLax((ModuleContext)this.context);
        if (expr instanceof Expr.Ref && (expr = (ref = (Expr.Ref)expr).resolvedVar()) instanceof DefVar) {
            DefVar defVar = (DefVar)expr;
            expr = defVar.core;
            if (expr instanceof FnDef) {
                FnDef fn = (FnDef)expr;
                if (fn.body.isLeft()) {
                    return fn;
                }
            }
        }
        System.out.println(parseTree);
        return null;
    }

    @NotNull
    public ReplContext getContext() {
        return this.context;
    }
}

