/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import kala.value.LazyValue;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.parse.AyaProducer;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.GeneralizedVar;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.ClassDecl;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.concrete.visitor.StmtFolder;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.MemberDef;
import org.aya.core.def.PrimDef;
import org.aya.core.term.Term;
import org.aya.generic.AyaDocile;
import org.aya.parser.AyaParserDefinitionBase;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Link;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.GenerateKind;
import org.aya.ref.LocalVar;
import org.aya.resolve.context.ModuleName;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SyntaxHighlight(@Nullable ImmutableSeq<String> currentFileModule) implements StmtFolder<MutableList<HighlightInfo>>
{
    @NotNull
    public static final TokenSet SPECIAL_SYMBOL = TokenSet.orSet((TokenSet[])new TokenSet[]{AyaParserDefinitionBase.UNICODES, AyaParserDefinitionBase.MARKERS, AyaParserDefinitionBase.DELIMITERS});

    @NotNull
    public static ImmutableSeq<HighlightInfo> highlight(@Nullable ImmutableSeq<String> currentFileModule, @NotNull Option<SourceFile> sourceFile, @NotNull ImmutableSeq<Stmt> program) {
        SyntaxHighlight prettier = new SyntaxHighlight(currentFileModule);
        ImmutableSeq semantics = program.flatMap((Function)((Object)prettier));
        if (sourceFile.isDefined()) {
            SourceFile file = (SourceFile)sourceFile.get();
            FlexLexer lexer = AyaParserDefinitionBase.createLexer((boolean)false);
            lexer.reset((CharSequence)file.sourceCode(), 0, file.sourceCode().length(), 0);
            ImmutableSeq addition = lexer.allTheWayDown().view().mapNotNull(token -> {
                IElementType tokenType = token.type();
                if (AyaParserDefinitionBase.KEYWORDS.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.Keyword);
                }
                if (AyaParserDefinitionBase.SKIP_COMMENTS.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.Comment);
                }
                if (SPECIAL_SYMBOL.contains(tokenType)) {
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), HighlightInfo.LitKind.SpecialSymbol);
                }
                if (tokenType == TokenType.WHITE_SPACE) {
                    String text = token.range().substring(file.sourceCode());
                    return new HighlightInfo.Lit(AyaProducer.sourcePosOf(token, file), text.contains("\n") ? HighlightInfo.LitKind.Eol : HighlightInfo.LitKind.Whitespace);
                }
                return null;
            }).toImmutableSeq();
            semantics = semantics.concat((SeqLike)addition);
        }
        return semantics;
    }

    @NotNull
    private MutableList<HighlightInfo> add(@NotNull MutableList<HighlightInfo> x, @NotNull HighlightInfo info) {
        x.append((Object)info);
        return x;
    }

    @NotNull
    public MutableList<HighlightInfo> init() {
        return MutableList.create();
    }

    @NotNull
    public MutableList<HighlightInfo> foldVarRef(@NotNull MutableList<HighlightInfo> acc, @NotNull AnyVar var, @NotNull SourcePos pos, @NotNull LazyValue<@Nullable Term> type) {
        return this.add(acc, this.linkRef(pos, var, (AyaDocile)type.get()));
    }

    @NotNull
    public MutableList<HighlightInfo> foldVarDecl(@NotNull MutableList<HighlightInfo> acc, @NotNull AnyVar var, @NotNull SourcePos pos, @NotNull LazyValue<@Nullable Term> type) {
        LocalVar v;
        if (var instanceof LocalVar && (v = (LocalVar)var).isGenerated()) {
            return acc;
        }
        return this.add(acc, this.linkDef(pos, var, (AyaDocile)type.get()));
    }

    @NotNull
    public MutableList<HighlightInfo> fold(@NotNull MutableList<HighlightInfo> acc, @NotNull Expr expr) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.LitInt.class, Expr.LitString.class}, (Object)expr3, n)) {
            case 0 -> {
                Expr.LitInt lit = (Expr.LitInt)expr3;
                yield this.add(acc, HighlightInfo.LitKind.Int.toLit(lit.sourcePos()));
            }
            case 1 -> {
                Expr.LitString lit = (Expr.LitString)expr3;
                yield this.add(acc, HighlightInfo.LitKind.String.toLit(lit.sourcePos()));
            }
            default -> (MutableList<HighlightInfo>)super.fold(acc, expr);
        };
    }

    @NotNull
    public MutableList<HighlightInfo> fold(@NotNull MutableList<HighlightInfo> acc, @NotNull Pattern pat) {
        Pattern pattern = pat;
        Objects.requireNonNull(pattern);
        Pattern pattern2 = pattern;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Number.class}, (Object)pattern2, n)) {
            case 0 -> {
                SourcePos var7_5;
                SourcePos pos = var7_5 = SyntaxHighlight.$proxy$sourcePos((Pattern.Number)pattern2);
                int var7_6 = SyntaxHighlight.$proxy$number((Pattern.Number)pattern2);
                int $ = var7_6;
                yield this.add(acc, HighlightInfo.LitKind.Int.toLit(pos));
            }
            default -> (MutableList<HighlightInfo>)super.fold(acc, pat);
        };
    }

    @NotNull
    public MutableList<HighlightInfo> foldModuleRef(@NotNull MutableList<HighlightInfo> acc, @NotNull SourcePos pos, @NotNull ModuleName path) {
        Link link = this.currentFileModule != null && this.currentFileModule.sameElements((Iterable)path.ids()) ? Link.loc((String)path.toString()) : Link.cross((ImmutableSeq)path.ids(), null);
        return this.add(acc, HighlightInfo.DefKind.Module.toRef(pos, link, null));
    }

    @NotNull
    public MutableList<HighlightInfo> foldModuleDecl(@NotNull MutableList<HighlightInfo> acc, @NotNull SourcePos pos, @NotNull ModuleName path) {
        return this.add(acc, HighlightInfo.DefKind.Module.toDef(pos, (Link)Link.loc((String)path.toString()), null));
    }

    @NotNull
    private HighlightInfo linkDef(@NotNull SourcePos sourcePos, @NotNull AnyVar var, @Nullable AyaDocile type) {
        return SyntaxHighlight.kindOf(var).toDef(sourcePos, BasePrettier.linkIdOf(this.currentFileModule, (AnyVar)var), type);
    }

    @NotNull
    private HighlightInfo linkRef(@NotNull SourcePos sourcePos, @NotNull AnyVar var, @Nullable AyaDocile type) {
        if (var instanceof LocalVar) {
            String string;
            String $ = string = SyntaxHighlight.$proxy$name((LocalVar)var);
            String $$ = string = SyntaxHighlight.$proxy$definition((LocalVar)var);
            string = SyntaxHighlight.$proxy$generateKind((LocalVar)var);
            if (string instanceof GenerateKind.Generalized) {
                GeneralizedVar generalizedVar;
                GeneralizedVar origin = generalizedVar = SyntaxHighlight.$proxy$origin((GenerateKind.Generalized)string);
                return this.linkRef(sourcePos, (AnyVar)origin, type);
            }
        }
        return SyntaxHighlight.kindOf(var).toRef(sourcePos, BasePrettier.linkIdOf(this.currentFileModule, (AnyVar)var), type);
    }

    @NotNull
    public static HighlightInfo.DefKind kindOf(@NotNull AnyVar var) {
        HighlightInfo.DefKind defKind;
        AnyVar anyVar = var;
        Objects.requireNonNull(anyVar);
        AnyVar anyVar2 = anyVar;
        int n = 0;
        block20: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, LocalVar.class, LocalVar.class}, (Object)anyVar2, n)) {
                case 0: {
                    GeneralizedVar ignored = (GeneralizedVar)anyVar2;
                    defKind = HighlightInfo.DefKind.Generalized;
                    break block20;
                }
                case 1: {
                    Decl decl;
                    DefVar defVar = (DefVar)anyVar2;
                    record P(Decl decl, GenericDef def) {
                    }
                    P p = new P(defVar.concrete, defVar.core);
                    Objects.requireNonNull(p);
                    P p2 = p;
                    int n2 = 0;
                    block21: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{P.class, P.class, P.class, P.class, P.class, P.class, P.class, P.class, P.class, P.class, P.class, P.class}, (Object)p2, n2)) {
                            default: {
                                throw new RuntimeException(null, null);
                            }
                            case 0: {
                                decl = SyntaxHighlight.$proxy$decl(p2);
                                if (!(decl instanceof TeleDecl.FnDecl)) {
                                    n2 = 1;
                                    continue block21;
                                }
                                TeleDecl.FnDecl $ = (TeleDecl.FnDecl)decl;
                                Decl $$ = decl = SyntaxHighlight.$proxy$def(p2);
                                defKind = HighlightInfo.DefKind.Fn;
                                break block20;
                            }
                            case 1: {
                                decl = SyntaxHighlight.$proxy$decl(p2);
                                if (!(decl instanceof ClassDecl)) {
                                    n2 = 2;
                                    continue block21;
                                }
                                ClassDecl $ = (ClassDecl)decl;
                                Decl $$ = decl = SyntaxHighlight.$proxy$def(p2);
                                defKind = HighlightInfo.DefKind.Clazz;
                                break block20;
                            }
                            case 2: {
                                decl = SyntaxHighlight.$proxy$decl(p2);
                                if (!(decl instanceof TeleDecl.ClassMember)) {
                                    n2 = 3;
                                    continue block21;
                                }
                                TeleDecl.ClassMember $ = (TeleDecl.ClassMember)decl;
                                Decl $$ = decl = SyntaxHighlight.$proxy$def(p2);
                                defKind = HighlightInfo.DefKind.Member;
                                break block20;
                            }
                            case 3: {
                                decl = SyntaxHighlight.$proxy$decl(p2);
                                if (!(decl instanceof TeleDecl.DataDecl)) {
                                    n2 = 4;
                                    continue block21;
                                }
                                TeleDecl.DataDecl $ = (TeleDecl.DataDecl)decl;
                                Decl $$ = decl = SyntaxHighlight.$proxy$def(p2);
                                defKind = HighlightInfo.DefKind.Data;
                                break block20;
                            }
                            case 4: {
                                decl = SyntaxHighlight.$proxy$decl(p2);
                                if (!(decl instanceof TeleDecl.DataCtor)) {
                                    n2 = 5;
                                    continue block21;
                                }
                                TeleDecl.DataCtor $ = (TeleDecl.DataCtor)decl;
                                Decl $$ = decl = SyntaxHighlight.$proxy$def(p2);
                                defKind = HighlightInfo.DefKind.Con;
                                break block20;
                            }
                            case 5: {
                                decl = SyntaxHighlight.$proxy$decl(p2);
                                if (!(decl instanceof TeleDecl.PrimDecl)) {
                                    n2 = 6;
                                    continue block21;
                                }
                                TeleDecl.PrimDecl $ = (TeleDecl.PrimDecl)decl;
                                Decl $$ = decl = SyntaxHighlight.$proxy$def(p2);
                                defKind = HighlightInfo.DefKind.Prim;
                                break block20;
                            }
                            case 6: {
                                Decl $ = decl = SyntaxHighlight.$proxy$decl(p2);
                                decl = SyntaxHighlight.$proxy$def(p2);
                                if (!(decl instanceof FnDef)) {
                                    n2 = 7;
                                    continue block21;
                                }
                                FnDef $$ = (FnDef)decl;
                                defKind = HighlightInfo.DefKind.Fn;
                                break block20;
                            }
                            case 7: {
                                Decl $ = decl = SyntaxHighlight.$proxy$decl(p2);
                                decl = SyntaxHighlight.$proxy$def(p2);
                                if (!(decl instanceof ClassDef)) {
                                    n2 = 8;
                                    continue block21;
                                }
                                ClassDef $$ = (ClassDef)decl;
                                defKind = HighlightInfo.DefKind.Clazz;
                                break block20;
                            }
                            case 8: {
                                Decl $ = decl = SyntaxHighlight.$proxy$decl(p2);
                                decl = SyntaxHighlight.$proxy$def(p2);
                                if (!(decl instanceof MemberDef)) {
                                    n2 = 9;
                                    continue block21;
                                }
                                MemberDef $$ = (MemberDef)decl;
                                defKind = HighlightInfo.DefKind.Member;
                                break block20;
                            }
                            case 9: {
                                Decl $ = decl = SyntaxHighlight.$proxy$decl(p2);
                                decl = SyntaxHighlight.$proxy$def(p2);
                                if (!(decl instanceof DataDef)) {
                                    n2 = 10;
                                    continue block21;
                                }
                                DataDef $$ = (DataDef)decl;
                                defKind = HighlightInfo.DefKind.Data;
                                break block20;
                            }
                            case 10: {
                                Decl $ = decl = SyntaxHighlight.$proxy$decl(p2);
                                decl = SyntaxHighlight.$proxy$def(p2);
                                if (!(decl instanceof CtorDef)) {
                                    n2 = 11;
                                    continue block21;
                                }
                                CtorDef $$ = (CtorDef)decl;
                                defKind = HighlightInfo.DefKind.Con;
                                break block20;
                            }
                            case 11: 
                        }
                        Decl $ = decl = SyntaxHighlight.$proxy$decl(p2);
                        decl = SyntaxHighlight.$proxy$def(p2);
                        if (decl instanceof PrimDef) break;
                        n2 = 12;
                    }
                    PrimDef $$ = (PrimDef)decl;
                    defKind = HighlightInfo.DefKind.Prim;
                    break block20;
                }
                case 2: {
                    GeneralizedVar generalizedVar;
                    String string;
                    String $ = string = SyntaxHighlight.$proxy$name((LocalVar)anyVar2);
                    String $$ = string = SyntaxHighlight.$proxy$definition((LocalVar)anyVar2);
                    string = SyntaxHighlight.$proxy$generateKind((LocalVar)anyVar2);
                    if (!(string instanceof GenerateKind.Generalized)) {
                        n = 3;
                        continue block20;
                    }
                    GeneralizedVar $$$ = generalizedVar = SyntaxHighlight.$proxy$origin((GenerateKind.Generalized)string);
                    defKind = HighlightInfo.DefKind.Generalized;
                    break block20;
                }
                case 3: {
                    LocalVar ignored = (LocalVar)anyVar2;
                    defKind = HighlightInfo.DefKind.LocalVar;
                    break block20;
                }
                default: {
                    defKind = HighlightInfo.DefKind.Unknown;
                    break block20;
                }
            }
            break;
        }
        return defKind;
    }

    private static /* synthetic */ SourcePos $proxy$sourcePos(Pattern.Number arg0) {
        try {
            return arg0.sourcePos();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ int $proxy$number(Pattern.Number arg0) {
        try {
            return arg0.number();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ String $proxy$name(LocalVar arg0) {
        try {
            return arg0.name();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ SourcePos $proxy$definition(LocalVar arg0) {
        try {
            return arg0.definition();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ GenerateKind $proxy$generateKind(LocalVar arg0) {
        try {
            return arg0.generateKind();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ GeneralizedVar $proxy$origin(GenerateKind.Generalized arg0) {
        try {
            return arg0.origin();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Decl $proxy$decl(1P arg0) {
        try {
            return arg0.decl();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ GenericDef $proxy$def(1P arg0) {
        try {
            return arg0.def();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }
}

