/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import com.intellij.openapi.util.text.StringUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.text.StringSlice;
import kala.tuple.Tuple2;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.utils.InlineHintProblem;
import org.aya.concrete.remark.AyaLiterate;
import org.aya.generic.AyaDocile;
import org.aya.literate.Literate;
import org.aya.literate.LiterateConsumer;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Language;
import org.aya.pretty.doc.Link;
import org.aya.pretty.doc.Style;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FaithfulPrettier(@NotNull ImmutableSeq<Problem> problems, @NotNull ImmutableSeq<HighlightInfo> highlights, @NotNull PrettierOptions options) implements LiterateConsumer
{
    public void accept(@NotNull Literate literate) {
        if (literate instanceof AyaLiterate.AyaVisibleCodeBlock) {
            AyaLiterate.AyaVisibleCodeBlock code = (AyaLiterate.AyaVisibleCodeBlock)literate;
            if (code.sourcePos != null) {
                code.highlighted = this.highlight(code.code, code.sourcePos);
            }
        }
        super.accept(literate);
    }

    private static void checkHighlights(@NotNull ImmutableSeq<HighlightInfo> highlights) {
        highlights.foldLeft((Object)-1, (lastEndIndex, h) -> {
            SourcePos sp = h.sourcePos();
            if (sp.tokenStartIndex() > sp.tokenEndIndex()) {
                throw new IllegalArgumentException("Invalid source pos: " + String.valueOf(sp));
            }
            if (lastEndIndex >= sp.tokenStartIndex()) {
                throw new IllegalArgumentException("Intersect with previous source pos: " + String.valueOf(sp));
            }
            return sp.tokenEndIndex();
        });
    }

    @NotNull
    private static ImmutableSeq<HighlightInfo> merge(@NotNull SourcePos codeRange, @NotNull PrettierOptions options, @NotNull ImmutableSeq<HighlightInfo> highlights, @NotNull ImmutableSeq<Problem> problems) {
        ImmutableSeq highlightInRange = highlights.view().filter(h -> h.sourcePos() != SourcePos.NONE).filterNot(h -> h.sourcePos().isEmpty()).filter(x -> codeRange.containsIndex(x.sourcePos())).sorted().distinct().toImmutableSeq();
        FaithfulPrettier.checkHighlights((ImmutableSeq<HighlightInfo>)highlightInRange);
        ImmutableSeq problemsInRange = problems.view().filter(p -> codeRange.containsIndex(p.sourcePos())).flatMap(p -> InlineHintProblem.withInlineHints(p, options)).distinct().toImmutableSeq();
        return (ImmutableSeq)problemsInRange.foldLeft((Object)highlightInRange, (acc, p) -> {
            Tuple2 partition = acc.partition(h -> p.sourcePos().containsIndex(h.sourcePos()));
            ImmutableSeq inP = ((ImmutableSeq)partition.component1()).sorted();
            HighlightInfo.Err wrap = new HighlightInfo.Err((Problem)p, (ImmutableSeq<HighlightInfo>)inP);
            return ((ImmutableSeq)partition.component2()).appended((Object)wrap);
        });
    }

    @NotNull
    public Doc highlight(@NotNull String raw, @NotNull SourcePos codeRange) {
        ImmutableSeq merged = FaithfulPrettier.merge(codeRange, this.options, this.highlights, this.problems).sorted();
        FaithfulPrettier.checkHighlights((ImmutableSeq<HighlightInfo>)merged);
        return this.doHighlight(StringSlice.of((String)raw), codeRange.tokenStartIndex(), (ImmutableSeq<HighlightInfo>)merged);
    }

    @NotNull
    private Doc doHighlight(@NotNull StringSlice raw, int base, @NotNull ImmutableSeq<HighlightInfo> highlights) {
        MutableList docs = MutableList.create();
        for (HighlightInfo current : highlights) {
            KnifeCut knifeCut = FaithfulPrettier.twoKnifeThreeParts(raw, base, current.sourcePos());
            if (!knifeCut.before.isEmpty()) {
                docs.append((Object)Doc.plain((String)knifeCut.before.toString()));
            }
            Doc highlight = this.highlightOne(knifeCut.current.toString(), base, current);
            docs.append((Object)highlight);
            raw = knifeCut.remaining;
            base = knifeCut.base;
        }
        if (!raw.isEmpty()) {
            docs.append((Object)Doc.plain((String)raw.toString()));
        }
        return Doc.cat((SeqLike)docs);
    }

    @NotNull
    private Doc highlightOne(@NotNull String raw, int base, @NotNull HighlightInfo highlight) {
        if (raw.isEmpty()) {
            return Doc.empty();
        }
        HighlightInfo highlightInfo = highlight;
        Objects.requireNonNull(highlightInfo);
        HighlightInfo highlightInfo2 = highlightInfo;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HighlightInfo.Def.class, HighlightInfo.Ref.class, HighlightInfo.Lit.class, HighlightInfo.Err.class}, (Object)highlightInfo2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                HighlightInfo.Def def = (HighlightInfo.Def)highlightInfo2;
                yield Doc.linkDef((Doc)this.highlightVar(raw, def.kind()), (Link)def.target(), (String)this.hover(def.type()));
            }
            case 1 -> {
                HighlightInfo.Ref ref = (HighlightInfo.Ref)highlightInfo2;
                yield Doc.linkRef((Doc)this.highlightVar(raw, ref.kind()), (Link)ref.target(), (String)this.hover(ref.type()));
            }
            case 2 -> {
                HighlightInfo.Lit lit = (HighlightInfo.Lit)highlightInfo2;
                yield this.highlightLit(raw, lit.kind());
            }
            case 3 -> {
                Style style;
                HighlightInfo.Err err = (HighlightInfo.Err)highlightInfo2;
                Doc doc = this.doHighlight(StringSlice.of((String)raw), base, err.children());
                switch (err.problem().level()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ERROR: {
                        Style v2 = BasePrettier.ERROR;
                        break;
                    }
                    case WARN: {
                        Style v2 = BasePrettier.WARNING;
                        break;
                    }
                    case GOAL: {
                        Style v2 = BasePrettier.GOAL;
                        break;
                    }
                    case INFO: {
                        Style v2 = style = null;
                    }
                }
                if (style == null) {
                    yield doc;
                }
                yield new Doc.Tooltip(Doc.styled((Style)style, (Doc)doc), () -> Doc.codeBlock((Language)Language.Builtin.Aya, (Doc)err.problem().brief(this.options).toDoc()));
            }
        };
    }

    @Nullable
    private String hover(@Nullable AyaDocile term) {
        if (term == null) {
            return null;
        }
        return term.toDoc(this.options()).commonRender();
    }

    @NotNull
    private Doc highlightVar(@NotNull String raw, @NotNull HighlightInfo.DefKind defKind) {
        Style style = switch (defKind) {
            default -> throw new IncompatibleClassChangeError();
            case HighlightInfo.DefKind.Data -> BasePrettier.DATA;
            case HighlightInfo.DefKind.Con -> BasePrettier.CON;
            case HighlightInfo.DefKind.Clazz -> BasePrettier.CLAZZ;
            case HighlightInfo.DefKind.Member -> BasePrettier.MEMBER;
            case HighlightInfo.DefKind.Fn -> BasePrettier.FN;
            case HighlightInfo.DefKind.Prim -> BasePrettier.PRIM;
            case HighlightInfo.DefKind.Generalized -> BasePrettier.GENERALIZED;
            case HighlightInfo.DefKind.LocalVar -> BasePrettier.LOCAL_VAR;
            case HighlightInfo.DefKind.Unknown, HighlightInfo.DefKind.Module -> null;
        };
        return style != null ? Doc.styled((Style)style, (String)raw) : Doc.plain((String)raw);
    }

    @NotNull
    private Doc highlightLit(@NotNull String raw, @NotNull HighlightInfo.LitKind litKind) {
        return switch (litKind) {
            default -> throw new IncompatibleClassChangeError();
            case HighlightInfo.LitKind.Int, HighlightInfo.LitKind.Whitespace -> Doc.plain((String)raw);
            case HighlightInfo.LitKind.String -> Doc.plain((String)StringUtil.escapeStringCharacters((String)raw));
            case HighlightInfo.LitKind.Keyword -> Doc.styled((Style)BasePrettier.KEYWORD, (Doc)Doc.symbol((String)raw));
            case HighlightInfo.LitKind.Comment -> Doc.styled((Style)BasePrettier.COMMENT, (String)raw);
            case HighlightInfo.LitKind.SpecialSymbol -> Doc.symbol((String)raw);
            case HighlightInfo.LitKind.Eol -> Doc.cat((SeqLike)Seq.fill((int)raw.length(), (Object)Doc.line()));
        };
    }

    @NotNull
    private static KnifeCut twoKnifeThreeParts(@NotNull StringSlice raw, int base, @NotNull SourcePos twoKnife) {
        int beginPart1 = twoKnife.tokenStartIndex() - base;
        int endPart1 = twoKnife.tokenEndIndex() + 1 - base;
        StringSlice part0 = raw.subSequence(0, beginPart1);
        StringSlice part1 = raw.subSequence(beginPart1, endPart1);
        StringSlice part2 = raw.subSequence(endPart1, raw.length());
        return new KnifeCut(part0, part1, part2, twoKnife.tokenEndIndex() + 1);
    }

    record KnifeCut(@NotNull StringSlice before, @NotNull StringSlice current, @NotNull StringSlice remaining, int base) {
    }
}

